import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace StaffingPlanRecordsApi {
  export interface StaffingPlanRecords extends BaseModel {
    /**
     * 记录时间
     */
    recordDate?: string;
    /**
     * 上一年标题
     */
    lastYearTitle?: string;
    /**
     * 今年标题
     */
    currentYearTitle?: string;
    /**
     * 明年标题
     */
    nextYearTitle?: string;
    /**
     * 是否已初始化
     */
    initFlag?: string;
    /**
     * 备注
     */
    remark?: string;
  }
}

/**
 * 查询编制规划记录列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/employee/staffingPlanRecords/page', { params });
}
/**
 * 查询编制规划记录详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/employee/staffingPlanRecords/${id}`);
}
/**
 * 新增编制规划记录
 * @param data
 */
export function apiAdd(data: StaffingPlanRecordsApi.StaffingPlanRecords) {
  return requestClient.post('/employee/staffingPlanRecords', data);
}
/**
 * 修改编制规划记录
 * @param data
 */
export function apiUpdate(data: StaffingPlanRecordsApi.StaffingPlanRecords) {
  return requestClient.put('/employee/staffingPlanRecords', data);
}
/**
 * 删除编制规划记录
 * @param id
 */
export function apiDelete(id: Array<number> | number) {
  return requestClient.delete(`/employee/staffingPlanRecords/${id}`);
}
/**
 * 导出编制规划记录
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/employee/staffingPlanRecords/export', params);
}
