import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace LaborCostApi {
  export interface LaborCost extends BaseModel {
    /**
     * 记录时间
     */
    recordDate?: string;
    /**
     * 文件ID
     */
    ossId?: number;

    /**
     * 文件Key
     */
    fileKey?: string;
    /**
     * 备注
     */
    remark?: string;
  }
}

/**
 * 查询人工成本档案列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/employee/laborCost/page', { params });
}
/**
 * 查询人工成本档案详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/employee/laborCost/${id}`);
}
/**
 * 新增人工成本档案
 * @param data
 */
export function apiAdd(data: LaborCostApi.LaborCost) {
  return requestClient.post('/employee/laborCost', data);
}
/**
 * 修改人工成本档案
 * @param data
 */
export function apiUpdate(data: LaborCostApi.LaborCost) {
  return requestClient.put('/employee/laborCost', data);
}
/**
 * 删除人工成本档案
 * @param id
 */
export function apiDelete(id: Array<number> | number) {
  return requestClient.delete(`/employee/laborCost/${id}`);
}
/**
 * 导出人工成本档案
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/employee/laborCost/export', params);
}

