import type { RouteRecordRaw } from 'vue-router';

const routes: RouteRecordRaw[] = [
  // 人事管理
  {
    path: '/hr',
    name: 'HrManagement',
    meta: {
      title: '人事管理',
      keepAlive: true,
      icon: 'streamline-ultimate:human-resources-hierarchy-1',
      permission: ['dashboard'],
    },
    children: [
      {
        path: '/hr/employee/list',
        name: 'EmployeeInfoList',
        component: () => import('#/views/hr/employeeInfo/list.vue'),
        meta: {
          title: '员工信息列表',
          icon: 'fluent:people-28-regular',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/employeeInfo/list.vue',
        },
      },
      {
        path: '/hr/resignEmployee/list',
        name: 'ResignEmployeeList',
        component: () => import('#/views/hr/employeeInfo/list.vue'),
        meta: {
          title: '离职员工列表',
          icon: 'fluent:people-swap-28-regular',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/resignEmployee/list.vue',
        },
      },
      {
        path: '/hr/partTimeInfo/list',
        name: 'EmployeePartTimeInfoList',
        component: () => import('#/views/hr/partTimeInfo/list.vue'),
        meta: {
          title: '兼职员工列表',
          icon: 'fluent:people-star-48-regular',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/partTimeInfo/list.vue',
        },
      },
      {
        path: '/hr/phoneBook/list',
        name: 'PhoneBookList',
        component: () => import('#/views/hr/phoneBook/list.vue'),
        meta: {
          title: '电话本管理',
          icon: 'streamline-plump:contact-phonebook',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/phoneBook/list.vue',
        },
      },
      {
        path: '/hr/regularReminder/list',
        name: 'RegularReminderList',
        component: () => import('#/views/hr/regularReminder/list.vue'),
        meta: {
          title: '转正提醒管理',
          icon: 'solar:monitor-smartphone-outline',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/regularReminder/list.vue',
        },
      },
      {
        path: '/hr/contractExpiration/list',
        name: 'ContractExpirationReminder',
        component: () =>
          import('#/views/hr/contractExpirationReminder/list.vue'),
        meta: {
          title: '合同续约提醒',
          icon: 'material-symbols-light:contract-outline-rounded',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/contractExpirationReminder/list.vue',
        },
      },
      {
        path: '/hr/changeLog/list',
        name: 'EmployeeChangeLogList',
        component: () => import('#/views/hr/changeLog/list.vue'),
        meta: {
          title: '员工变动记录',
          icon: 'clarity:employee-group-line',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/changeLog/list.vue',
        },
      },
      {
        path: '/hr/training/list',
        name: 'EmployeeTrainingList',
        component: () => import('#/views/hr/training/list.vue'),
        meta: {
          title: '员工培训档案',
          icon: 'si:archive-line',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/training/list.vue',
        },
      },
      {
        path: '/hr/interviewProfile/list',
        name: 'InterviewProfileList',
        component: () => import('#/views/hr/interviewProfile/list.vue'),
        meta: {
          title: '面试档案',
          icon: 'solar:archive-check-linear',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/interviewProfile/list.vue',
        },
      },
      {
        path: '/hr/laborCost/list',
        name: 'EmployeeLaborCostList',
        component: () => import('#/views/hr/laborCost/list.vue'),
        meta: {
          title: '人工成本档案',
          icon: 'solar:archive-up-linear',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/laborCost/list.vue',
        },
      },
      {
        path: '/hr/report',
        name: 'HrReport',
        meta: {
          title: '报表',
          keepAlive: true,
          icon: 'oui:app-reporting',
          permission: ['dashboard'],
        },
        children: [
          {
            path: '/hr/report/changeAnalysis',
            name: 'EmployeeChangeAnalysisList',
            component: () => import('#/views/hr/changeAnalysis/list.vue'),
            meta: {
              title: '人员变化分析',
              icon: 'arcticons:one-hand-operation',
              keepAlive: true,
              permission: ['dashboard'],
              componentPath: '#/views/hr/changeAnalysis/list.vue',
            },
          },
          {
            path: '/hr/report/statusAnalysis',
            name: 'EmployeeStatusAnalysisList',
            component: () =>
              import('#/views/hr/employeeStatusAnalysis/list.vue'),
            meta: {
              title: '在职情况分析',
              icon: 'arcticons:one-hand-operation',
              keepAlive: true,
              permission: ['dashboard'],
              componentPath: '#/views/hr/employeeStatusAnalysis/list.vue',
            },
          },
        ],
      },
      {
        name: 'EmployeeFlowList',
        path: '/hr/employee/flow/list',
        // hidden: false,
        component: () => import('#/views/workflow/hrFlow/list.vue'),
        meta: {
          title: '人事申请',
          icon: 'fluent-mdl2:leave-user',
          noCache: false,
          componentPath: '#/views/workflow/hrFlow/list.vue',
          // link: null,
        },
      },
      {
        name: 'EmployeeFlowEdit',
        path: '/hr/employee/flow',
        // hidden: false,
        component: () => import('#/views/workflow/hrFlow/hrEdit.vue'),
        meta: {
          title: '人事申请编辑',
          icon: 'fluent-mdl2:leave-user',
          noCache: false,
          hideInMenu: true,
          componentPath: '#/views/workflow/hrFlow/hrEdit.vue',
          // link: null,
        },
      },
    ],
  },
];

export default routes;
