import { defineConfig } from '@vben/vite-config';

export default defineConfig(async () => {
  return {
    application: {},
    vite: {
      server: {
        proxy: {
          '/api': {
            changeOrigin: true,
            rewrite: (path) => path.replace(/^\/api/, ''),
            // mock代理目标地址
            target: 'http://localhost:9000/api',
            ws: true,
          },
          '/file-preview': {
            changeOrigin: true,
            rewrite: (path) => path.replace(/^\/file-preview/, ''),
            // mock代理目标地址
            target: 'http://172.16.200.110:18010/file-preview',
            ws: true,
          },
          '/getCorsFile': {
            changeOrigin: true,
            rewrite: (path) => path.replace(/^\/getCorsFile/, ''),
            // mock代理目标地址
            target: 'http://119.184.127.215:666/getCorsFile',
            ws: true,
          },
        },
      },
    },
  };
}) as any;
