import type { VbenFormSchema } from '#/adapter/form';
import type { OnActionClickFn, VxeTableGridOptions } from '#/adapter/vxe-table';
import type { StaffingPlanRecordsApi } from '#/api/hr/staffingPlanRecords';

export const querySchema: VbenFormSchema[] = [
  {
    component: 'DatePicker',
    componentProps: {
      picker: 'year',
      format: 'YYYY',
      valueFormat: 'YYYY',
    },
    fieldName: 'recordDate',
    label: '记录时间',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'lastYearTitle',
  //   label: '上一年标题',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'currentYearTitle',
  //   label: '今年标题',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'nextYearTitle',
  //   label: '明年标题',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'initFlag',
  //   label: '是否已初始化',
  // },
];

export function useColumns(
  onActionClick: OnActionClickFn<StaffingPlanRecordsApi.StaffingPlanRecords>,
): VxeTableGridOptions<StaffingPlanRecordsApi.StaffingPlanRecords>['columns'] {
  return [
    {
      title: '记录时间',
      field: 'recordDate',
      // formatter: 'formatDateTime',
    },
    // {
    //   title: '上一年标题',
    //   field: 'lastYearTitle',
    // },
    // {
    //   title: '今年标题',
    //   field: 'currentYearTitle',
    // },
    // {
    //   title: '明年标题',
    //   field: 'nextYearTitle',
    // },
    // {
    //   title: '是否已初始化',
    //   field: 'initFlag',
    // },
    {
      title: '备注',
      field: 'remark',
    },
    {
      align: 'right',
      cellRender: {
        attrs: {
          nameField: 'recordDate',
          nameTitle: '编制规划记录',
          onClick: onActionClick,
        },
        name: 'CellOperation',
        options: [
          {
            text: '明细',
            code: 'detail',
            accessCode: ['employee:staffingPlanRecords:edit'],
          }, // 明细数据
          {
            code: 'edit',
            accessCode: ['employee:staffingPlanRecords:edit'],
          }, // 默认的编辑按钮
          {
            code: 'delete',
            accessCode: ['employee:staffingPlanRecords:remove'],
          }, // 默认的删除按钮
        ],
      },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
