import type { VbenFormSchema } from '#/adapter/form';
import type { OnActionClickFn, VxeTableGridOptions } from '#/adapter/vxe-table';
import type { InterviewProfileApi } from '#/api/hr/interviewProfile';

import { getDictOptions, getTagDicts } from '#/utils/dict';

import { HrDictEnum } from '../dict-enum';

export const querySchema: VbenFormSchema[] = [
  // {
  //   component: 'Input',
  //   fieldName: 'employeeId',
  //   label: '员工信息ID',
  // },
  {
    component: 'Input',
    fieldName: 'jobPosition',
    label: '招揽岗位',
  },
  {
    component: 'Input',
    fieldName: 'name',
    label: '姓名',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'gender',
  //   label: '性别',
  // },
  {
    component: 'Input',
    fieldName: 'idCardNumber',
    label: '身份证号',
  },
  {
    component: 'Input',
    fieldName: 'education',
    label: '学历',
  },
  {
    component: 'Input',
    fieldName: 'school',
    label: '院校',
  },
  {
    component: 'Input',
    fieldName: 'major',
    label: '专业',
  },
  {
    component: 'Input',
    fieldName: 'phoneNumber',
    label: '联系方式',
  },
  {
    component: 'Input',
    fieldName: 'benchmarkEnterprise',
    label: '标杆企业',
  },
  {
    component: 'DatePicker',
    fieldName: 'interviewDate',
    label: '面试时间',
  },
  {
    component: 'Input',
    fieldName: 'interviewSituation',
    label: '面试情况',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_INTERVIEW_RESULT),
    },
    fieldName: 'interviewResult',
    label: '面试结果',
  },
];

export function useColumns(
  onActionClick: OnActionClickFn<InterviewProfileApi.InterviewProfile>,
): VxeTableGridOptions<InterviewProfileApi.InterviewProfile>['columns'] {
  return [
    // {
    //   title: '员工信息ID',
    //   field: 'employeeId',
    // },
    {
      title: '招揽岗位',
      field: 'jobPosition',
    },
    {
      title: '姓名',
      field: 'name',
    },
    {
      title: '性别',
      field: 'gender',
      cellRender: {
        name: 'CellTag',
        options: [getTagDicts(HrDictEnum.HR_USER_SEX)],
      },
    },
    {
      title: '身份证号',
      field: 'idCardNumber',
    },
    {
      title: '学历',
      field: 'education',
    },
    {
      title: '标杆企业',
      field: 'benchmarkEnterprise',
    },
    {
      title: '院校',
      field: 'school',
    },
    {
      title: '专业',
      field: 'major',
    },
    {
      title: '联系方式',
      field: 'phoneNumber',
    },
    {
      title: '面试时间',
      field: 'interviewDate',
      formatter: 'formatDateTime',
    },
    {
      title: '面试情况',
      field: 'interviewSituation',
    },
    {
      title: '面试结果',
      field: 'interviewResult',
      cellRender: {
        name: 'CellTag',
        options: [getTagDicts(HrDictEnum.HR_INTERVIEW_RESULT)],
      },
    },
    // {
    //   title: '备注',
    //   field: 'remark',
    // },
    {
      align: 'right',
      cellRender: {
        attrs: {
          nameField: 'name',
          nameTitle: '姓名',
          onClick: onActionClick,
        },
        name: 'CellOperation',
        options: [
          {
            code: 'edit',
            accessCode: ['employee:interviewProfile:edit'],
          }, // 默认的编辑按钮
          {
            code: 'delete',
            accessCode: ['employee:interviewProfile:remove'],
          }, // 默认的删除按钮
        ],
      },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
