import type { VbenFormSchema } from '#/adapter/form';
import type { VxeTableGridOptions } from '#/adapter/vxe-table';
import type { EmployeeStatusAnalysisApi } from '#/api/hr/employeeStatusAnalysis';

// import { DictEnum } from '@vben/constants';

// import { getDictOptions, getTagDicts } from '#/utils/dict';

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'plate',
    label: '公司',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'maleCount',
  //   label: '男性人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'femaleCount',
  //   label: '女性人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'under24Count',
  //   label: '24岁以下人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'age25To34Count',
  //   label: '25-34岁人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'age35To44Count',
  //   label: '35-44岁人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'over45Count',
  //   label: '45岁以上人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'belowCollegeCount',
  //   label: '专科以下人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'collegeCount',
  //   label: '专科人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'bachelorCount',
  //   label: '本科人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'masterCount',
  //   label: '硕士人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'lessThan2YearsCount',
  //   label: '小于2年人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'years2To5Count',
  //   label: '2年到5年人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'years5To10Count',
  //   label: '5年到10年人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'over10YearsCount',
  //   label: '10年以上人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'maleRatio',
  //   label: '男性占比',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'femaleRatio',
  //   label: '女性占比',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'under24Ratio',
  //   label: '24岁以下占比',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'age25To34Ratio',
  //   label: '25-34岁占比',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'age35To44Ratio',
  //   label: '35-44岁占比',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'over45Ratio',
  //   label: '45岁以上占比',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'belowCollegeRatio',
  //   label: '专科以下占比',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'collegeRatio',
  //   label: '专科占比',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'bachelorRatio',
  //   label: '本科占比',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'masterRatio',
  //   label: '硕士占比',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'lessThan2YearsRatio',
  //   label: '小于2年占比',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'years2To5Ratio',
  //   label: '2年到5年占比',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'years5To10Ratio',
  //   label: '5年到10年占比',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'over10YearsRatio',
  //   label: '10年以上占比',
  // },
];

export function useColumns(): VxeTableGridOptions<EmployeeStatusAnalysisApi.EmployeeStatusAnalysis>['columns'] {
  return [
    {
      title: '公司',
      field: 'plate',
    },
    {
      title: '总人数',
      field: 'totalCount',
    },
    {
      title: '性别分析',
      headerAlign: 'center',
      children: [
        {
          title: '男',
          field: 'maleCount',
        },
        {
          title: '女',
          field: 'femaleCount',
        },
      ],
    },
    {
      title: '年龄结构分析',
      headerAlign: 'center',
      children: [
        {
          title: '24岁以下',
          field: 'under24Count',
        },
        {
          title: '25-34岁',
          field: 'age25To34Count',
        },
        {
          title: '35-44岁',
          field: 'age35To44Count',
        },
        {
          title: '45岁以上',
          field: 'over45Count',
        },
      ],
    },
    {
      title: '教育结构分析',
      headerAlign: 'center',
      children: [
        {
          title: '专科以下',
          field: 'belowCollegeCount',
        },
        {
          title: '专科',
          field: 'juniorCollegeCount',
        },
        {
          title: '本科',
          field: 'bachelorCount',
        },
        {
          title: '硕士',
          field: 'postgraduateCount',
        },
      ],
    },
    {
      title: '工龄结构分析',
      headerAlign: 'center',
      children: [
        {
          title: '＜2年',
          field: 'lessThan2YearsCount',
        },
        {
          title: '≥2年＜5年',
          field: 'years2To5Count',
        },
        {
          title: '≥5年＜10年',
          field: 'years5To10Count',
        },
        {
          title: '≥10年以上',
          field: 'over10YearsCount',
        },
      ],
    },
    {
      title: '性别分析占比',
      headerAlign: 'center',
      children: [
        {
          title: '男',
          field: 'maleRatio',
        },
        {
          title: '女',
          field: 'femaleRatio',
        },
      ],
    },
    {
      title: '年龄结构分析占比',
      headerAlign: 'center',
      children: [
        {
          title: '24岁以下',
          field: 'under24Ratio',
        },
        {
          title: '25-34岁',
          field: 'age25To34Ratio',
        },
        {
          title: '35-44岁',
          field: 'age35To44Ratio',
        },
        {
          title: '45岁以上',
          field: 'over45Ratio',
        },
      ],
    },
    {
      title: '教育结构分析占比',
      headerAlign: 'center',
      children: [
        {
          title: '专科以下',
          field: 'belowCollegeRatio',
        },
        {
          title: '专科',
          field: 'juniorCollegeRatio',
        },
        {
          title: '本科',
          field: 'bachelorRatio',
        },
        {
          title: '硕士',
          field: 'postgraduateRatio',
        },
      ],
    },
    {
      title: '工龄结构分析占比',
      headerAlign: 'center',
      children: [
        {
          title: '＜2年',
          field: 'lessThan2YearsRatio',
        },
        {
          title: '≥2年＜5年',
          field: 'years2To5Ratio',
        },
        {
          title: '≥5年＜10年',
          field: 'years5To10Ratio',
        },
        {
          title: '≥10年以上',
          field: 'over10YearsRatio',
        },
      ],
    },

    // {
    //   align: 'right',
    //   cellRender: {
    //     attrs: {
    //       nameField: 'name',
    //       nameTitle: '在职人员情况分析',
    //       onClick: onActionClick,
    //     },
    //     name: 'CellOperation',
    //     options: [
    //       {
    //         code: 'edit',
    //         accessCode: ['employee:employeeStatusAnalysis:edit'],
    //       }, // 默认的编辑按钮
    //       {
    //         code: 'delete',
    //         accessCode: ['employee:employeeStatusAnalysis:remove'],
    //       }, // 默认的删除按钮
    //     ],
    //   },
    //   field: 'action',
    //   fixed: 'right',
    //   headerAlign: 'center',
    //   resizable: false,
    //   showOverflow: false,
    //   title: '操作',
    //   width: 'auto',
    // },
  ];
}
