import type { VbenFormSchema } from '#/adapter/form';
import type { VxeTableGridOptions } from '#/adapter/vxe-table';
import type { ChangeLogApi } from '#/api/hr/changeLog';

import { getDictOptions, getTagDicts } from '#/utils/dict';

import { HrDictEnum } from '../dict-enum';

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_CHANGE_LOG_TYPE),
    },
    fieldName: 'type',
    label: '变动类型',
  },
  {
    component: 'Input',
    fieldName: 'applyCode',
    label: '流程申请编号',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'plateId',
  //   label: '板块ID',
  // },
  {
    component: 'Input',
    fieldName: 'plate',
    label: '板块',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'deptId',
  //   label: '部门ID',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'employeeId',
  //   label: '员工ID',
  // },
  {
    component: 'DatePicker',
    fieldName: 'changeDate',
    label: '变动时间',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_RESIGNATION_TYPE),
    },
    fieldName: 'resignType',
    label: '离职类型',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_RESIGN_YEARS_OF_SERVICE_TYPE),
    },
    fieldName: 'resignYearsOfServiceType',
    label: '离职工龄类型',
  },
];

export function useColumns(): VxeTableGridOptions<ChangeLogApi.ChangeLog>['columns'] {
  return [
    {
      title: '变动类型',
      field: 'type',
      cellRender: {
        name: 'CellTag',
        options: [getTagDicts(HrDictEnum.HR_CHANGE_LOG_TYPE)],
      },
    },
    {
      title: '流程申请编号',
      field: 'applyCode',
    },
    // {
    //   title: '板块ID',
    //   field: 'plateId',
    // },
    {
      title: '板块',
      field: 'plate',
    },
    {
      title: '部门ID',
      field: 'deptId',
    },
    {
      title: '员工ID',
      field: 'employeeId',
    },
    {
      title: '变动时间',
      field: 'changeDate',
      formatter: 'formatDateTime',
    },
    {
      title: '离职类型',
      field: 'resignType',
      cellRender: {
        name: 'CellTag',
        options: [getTagDicts(HrDictEnum.HR_RESIGNATION_TYPE)],
      },
    },
    {
      title: '离职工龄类型',
      field: 'resignYearsOfServiceType',
      cellRender: {
        name: 'CellTag',
        options: [getTagDicts(HrDictEnum.HR_RESIGN_YEARS_OF_SERVICE_TYPE)],
      },
    },
    {
      align: 'right',
      slots: { default: 'action' },
      // cellRender: {
      //   attrs: {
      //     nameField: 'name',
      //     nameTitle: '员工变动记录',
      //     onClick: onActionClick,
      //   },
      //   name: 'CellOperation',
      //   options: [
      //     {
      //       code: 'edit',
      //       accessCode: ['employee:changeLog:edit'],
      //     }, // 默认的编辑按钮
      //     {
      //       code: 'delete',
      //       accessCode: ['employee:changeLog:remove'],
      //     }, // 默认的删除按钮
      //   ],
      // },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
