import type { VbenFormSchema } from '#/adapter/form';
import type { VxeTableGridOptions } from '#/adapter/vxe-table';

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'userName',
    label: '用户账号',
  },
  {
    component: 'Input',
    fieldName: 'phonenumber',
    label: '手机号码',
  },
];

export const columns: VxeTableGridOptions['columns'] = [
  { type: 'checkbox', width: 60 },
  {
    title: '用户账号',
    field: 'username',
  },
  {
    title: '用户昵称',
    field: 'name',
  },
  // {
  //   title: '邮箱',
  //   field: 'email',
  // },
  {
    title: '手机号',
    field: 'phone',
  },
  {
    field: 'action',
    fixed: 'right',
    slots: { default: 'action' },
    title: '操作',
    resizable: false,
    width: 'auto',
  },
];
