import type { VbenFormSchema } from '#/adapter/form';
import type { OnActionClickFn, VxeTableGridOptions } from '#/adapter/vxe-table';
import type { PostApi } from '#/api/auth/post';

import { DictEnum } from '@vben/constants';

import { getDictOptions, getTagDicts } from '#/utils/dict';

export const querySchema: VbenFormSchema[] = [
  // {
  //   component: 'Input',
  //   fieldName: 'deptId',
  //   label: '部门ID',
  // },
  {
    component: 'Input',
    fieldName: 'postCode',
    label: '岗位编码',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'postCategory',
  //   label: '岗位类别编码',
  // },
  {
    component: 'Input',
    fieldName: 'postName',
    label: '岗位名称',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'postSort',
  //   label: '显示顺序',
  // },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(DictEnum.SYS_COMMON_STATUS, true),
    },
    fieldName: 'status',
    label: '状态',
  },
];

export function useColumns(
  onActionClick: OnActionClickFn<PostApi.Post>,
): VxeTableGridOptions<PostApi.Post>['columns'] {
  return [
    {
      title: '部门',
      field: 'deptName',
    },
    {
      title: '岗位编码',
      field: 'postCode',
    },
    {
      title: '岗位类别编码',
      field: 'postCategory',
    },
    {
      title: '岗位名称',
      field: 'postName',
    },
    {
      title: '显示顺序',
      field: 'postSort',
    },
    {
      title: '状态',
      field: 'status',
      cellRender: {
        name: 'CellTag',
        options: [getTagDicts(DictEnum.SYS_COMMON_STATUS, true)],
      },
    },
    {
      title: '备注',
      field: 'remark',
    },
    {
      align: 'right',
      cellRender: {
        attrs: {
          nameField: 'postName',
          nameTitle: '岗位信息',
          onClick: onActionClick,
        },
        name: 'CellOperation',
        options: [
          {
            code: 'edit',
            accessCode: ['auth:post:edit'],
          }, // 默认的编辑按钮
          {
            code: 'delete',
            accessCode: ['auth:post:remove'],
          }, // 默认的删除按钮
        ],
      },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
