import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace SysJobApi {
  export interface SysJob extends BaseModel {
    /**
     * 1、java类;2、spring bean名称;3、rest调用;4、jar调用;9其他
     */
    jobType?: string;
    /**
     * spring bean名称
     */
    className?: string;
    /**
     * 方法名
     */
    methodName?: string;
    /**
     * 参数
     */
    params?: string;
    /**
     * cron表达式
     */
    cronExpression?: string;
    /**
     * 任务状态  (0、未发布;1、已发布
     */
    status?: string;
    /**
     * 备注
     */
    remark?: string;
    /**
     * 系统标识
     */
    clientId?: string;
  }
}

/**
 * 查询定时任务列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/system/job/page', { params });
}
/**
 * 查询定时任务详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/system/job/${id}`);
}
/**
 * 新增定时任务
 * @param data
 */
export function apiAdd(data: SysJobApi.SysJob) {
  return requestClient.post('/system/job', data);
}
/**
 * 修改定时任务
 * @param data
 */
export function apiUpdate(data: SysJobApi.SysJob) {
  return requestClient.put('/system/job', data);
}
/**
 * 删除定时任务
 * @param id
 */
export function apiDelete(id: Array<number> | number) {
  return requestClient.delete(`/system/job/${id}`);
}
/**
 * 导出定时任务
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/system/job/export', params);
}
