import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace EmployeeRegularReminderApi {
  export interface EmployeeRegularReminder extends BaseModel {
    /**
     * 板块
     */
    plate?: string;
    /**
     * 一级部门
     */
    firstLevelDepartment?: string;
    /**
     * 二级部门
     */
    secondLevelDepartment?: string;
    /**
     * 三级部门
     */
    thirdLevelDepartment?: string;
    /**
     * 部门ID
     */
    deptId?: number;

    /**
     * 主岗位
     */
    position?: string;
    /**
     * 姓名
     */
    name?: string;
    /**
     * 手机号码
     */
    phoneNumber?: string;
    /**
     * 入职时间
     */
    entryDate?: string;
    /**
     * 转正时间
     */
    expectedRegularDate?: string;
    /**
     * 备注
     */
    remarks?: string;
  }
}

/**
 * 查询转正提醒列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/employee/regularReminder/page', { params });
}
// /**
//  * 查询转正提醒详细
//  * @param id
//  */
// export function apiDetail(id: number) {
//   return requestClient.get(`/employee/employeeRegularReminder/${id}`);
// }
// /**
//  * 新增转正提醒
//  * @param data
//  */
// export function apiAdd(data: EmployeeRegularReminderApi.EmployeeRegularReminder) {
//   return requestClient.post('/employee/employeeRegularReminder', data);
// }
// /**
//  * 修改转正提醒
//  * @param data
//  */
// export function apiUpdate(data: EmployeeRegularReminderApi.EmployeeRegularReminder) {
//   return requestClient.put('/employee/employeeRegularReminder', data);
// }
// /**
//  * 删除转正提醒
//  * @param id
//  */
// export function apiDelete(id: Array<number> | number) {
//   return requestClient.delete(`/employee/employeeRegularReminder/${id}`);
// }
/**
 * 导出转正提醒
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/employee/regularReminder/export', params);
}
