import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace PartTimeInfoApi {
  export interface PartTimeInfo extends BaseModel {
    /**
     * 板块
     */
    plate?: string;
    /**
     * 一级部门
     */
    firstLevelDepartment?: string;
    /**
     * 二级部门
     */
    secondLevelDepartment?: string;
    /**
     * 三级部门
     */
    thirdLevelDepartment?: string;
    /**
     * 部门ID
     */
    deptId?: number;

    /**
     * 岗位类型
     */
    positionType?: string;
    /**
     * 主岗位
     */
    position?: string;
    /**
     * 姓名
     */
    name?: string;
    /**
     * 性别
     */
    gender?: string;
    /**
     * 身份证号码
     */
    idCardNumber?: number;

    /**
     * 照片ID
     */
    ossId?: number;

    /**
     * 出生日期
     */
    birthDate?: string;
    /**
     * 年龄
     */
    age?: number;

    /**
     * 籍贯
     */
    nativePlace?: string;
    /**
     * 民族
     */
    ethnicity?: string;
    /**
     * 婚姻状况
     */
    maritalStatus?: string;
    /**
     * 政治面貌
     */
    politicalStatus?: string;
    /**
     * 手机号码
     */
    phoneNumber?: string;
    /**
     * 紧急联系人
     */
    emergencyContact?: string;
    /**
     * 紧急联系人电话
     */
    emergencyContactPhone?: string;
    /**
     * 家庭地址
     */
    homeAddress?: string;
    /**
     * 入职时间
     */
    entryDate?: string;
    /**
     * 全日制学历
     */
    fulltimeEducation?: string;
    /**
     * 全日制毕业院校
     */
    fulltimeSchool?: string;
    /**
     * 全日制专业
     */
    fulltimeMajor?: string;
    /**
     * 全日制毕业日期
     */
    fulltimeGraduationDate?: string;
    /**
     * 全日制学位
     */
    fulltimeDegree?: string;
    /**
     * 用工形式
     */
    employmentForm?: string;
    /**
     * 是否兼职
     */
    partTimeFlag?: string;
    /**
     * 签订兼职协议
     */
    partTimeAgreement?: string;
    /**
     * 协议主体
     */
    agreementEntity?: string;
    /**
     * 协议期限
     */
    agreementPeriod?: string;
    /**
     * 协议开始时间
     */
    agreementStartDate?: string;
    /**
     * 协议截止时间
     */
    agreementEndDate?: string;
    /**
     * 备注
     */
    remarks?: string;
    /**
     * 银行卡号
     */
    bankCardNumber?: string;
    /**
     * 开户行
     */
    bankName?: string;
    /**
     * 公司内是否有亲属关系
     */
    hasRelativeInCompany?: string;
    /**
     * 亲属姓名
     */
    relativeName?: string;
    /**
     * 介绍人
     */
    introducer?: string;
    /**
     * 介绍人关系
     */
    introducerRelation?: string;
    /**
     * 工资发放地
     */
    salaryLocation?: string;
    /**
     * 成本费用所属
     */
    costOfDept?: string;

    /**
     * 状态
     */
    status?: number;
    statusName?: string;
  }
}

/**
 * 查询兼职员工信息列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/employee/partTimeInfo/page', { params });
}
/**
 * 查询兼职员工信息详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/employee/partTimeInfo/${id}`);
}
/**
 * 展示员工信息详细
 * @param id
 */
export function apiInfoDetail(id: number) {
  return requestClient.get(`/employee/partTimeInfo/detail/${id}`);
}
/**
 * 新增兼职员工信息
 * @param data
 */
export function apiAdd(data: PartTimeInfoApi.PartTimeInfo) {
  return requestClient.post('/employee/partTimeInfo', data);
}
/**
 * 修改兼职员工信息
 * @param data
 */
export function apiUpdate(data: PartTimeInfoApi.PartTimeInfo) {
  return requestClient.put('/employee/partTimeInfo', data);
}
/**
 * 删除兼职员工信息
 * @param id
 */
export function apiDelete(id: Array<number> | number) {
  return requestClient.delete(`/employee/partTimeInfo/${id}`);
}
/**
 * 导出兼职员工信息
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/employee/partTimeInfo/export', params);
}

/**
 * 下载用户导入模板
 * @returns blob
 */
export function downloadImportTemplate() {
  return commonExport('/employee/partTimeInfo/importTemplate', {});
}

/**
 * 从excel导入用户
 * @param file
 * @returns void
 */
export function employeePartTimeImportData(file: Blob) {
  return requestClient.post<{ errMessage: string; success: boolean }>(
    '/employee/partTimeInfo/import',
    { file },
    {
      headers: {
        'Content-Type': 'multipart/form-data;charset=UTF-8',
      },
      isTransformResponse: false,
      responseReturn: 'body',
      timeout: 300_000,
    },
  );
}
