import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace ContractExpirationReminderApi {
  export interface ContractExpirationReminder extends BaseModel {
    /**
     * 板块
     */
    plate?: string;
    /**
     * 一级部门
     */
    firstLevelDepartment?: string;
    /**
     * 二级部门
     */
    secondLevelDepartment?: string;
    /**
     * 三级部门
     */
    thirdLevelDepartment?: string;
    /**
     * 部门ID
     */
    deptId?: number;

    /**
     * 主岗位
     */
    position?: string;
    /**
     * 姓名
     */
    name?: string;
    /**
     * 手机号码
     */
    phoneNumber?: string;
    /**
     * 劳动合同开始时间
     */
    contractStartDate?: string;
    /**
     * 劳动合同截止时间
     */
    contractEndDate?: string;
    /**
     * 合同形式
     */
    contractForm?: string;
    /**
     * 备注
     */
    remarks?: string;
  }
}

/**
 * 查询员工合同续签提醒列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/employee/contractExpiration/page', { params });
}
// /**
//  * 查询员工合同续签提醒详细
//  * @param id
//  */
// export function apiDetail(id: number) {
//   return requestClient.get(`/employee/contractExpirationReminder/${id}`);
// }
// /**
//  * 新增员工合同续签提醒
//  * @param data
//  */
// export function apiAdd(data: ContractExpirationReminderApi.ContractExpirationReminder) {
//   return requestClient.post('/employee/contractExpirationReminder', data);
// }
// /**
//  * 修改员工合同续签提醒
//  * @param data
//  */
// export function apiUpdate(data: ContractExpirationReminderApi.ContractExpirationReminder) {
//   return requestClient.put('/employee/contractExpirationReminder', data);
// }
// /**
//  * 删除员工合同续签提醒
//  * @param id
//  */
// export function apiDelete(id: Array<number> | number) {
//   return requestClient.delete(`/employee/contractExpirationReminder/${id}`);
// }
/**
 * 导出员工合同续签提醒
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/employee/contractExpiration/export', params);
}
