import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace ChangeLogApi {
  export interface ChangeLog extends BaseModel {
    /**
     * 异动类型
     */
    type?: string;
    typeName?: string;
    /**
     * 流程申请编号
     */
    applyCode?: string;
    /**
     * 板块ID
     */
    plateId?: number;

    /**
     * 板块
     */
    plate?: string;
    /**
     * 部门ID
     */
    deptId?: number;

    /**
     * 员工ID
     */
    employeeId?: number;

    /**
     * 异动时间
     */
    changeDate?: string;
    /**
     * 离职类型
     */
    resignType?: string;
    resignTypeName?: string;
    /**
     * 离职工龄类型
     */
    resignYearsOfServiceType?: string;
    resignYearsOfServiceTypeName?: string;
  }
}

/**
 * 查询员工异动记录列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/employee/changeLog/page', { params });
}
/**
 * 查询员工异动记录详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/employee/changeLog/${id}`);
}
/**
 * 新增员工异动记录
 * @param data
 */
export function apiAdd(data: ChangeLogApi.ChangeLog) {
  return requestClient.post('/employee/changeLog', data);
}
// /**
//  * 修改员工异动记录
//  * @param data
//  */
// export function apiUpdate(data: ChangeLogApi.ChangeLog) {
//   return requestClient.put('/employee/changeLog', data);
// }
// /**
//  * 删除员工异动记录
//  * @param id
//  */
// export function apiDelete(id: Array<number> | number) {
//   return requestClient.delete(`/employee/changeLog/${id}`);
// }
/**
 * 导出员工异动记录
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/employee/changeLog/export', params);
}
