import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace ChangeAnalysisApi {
  export interface ChangeAnalysis extends BaseModel {
    /**
     * 板块
     */
    plate?: string;
    /**
     * 板块ID
     */
    plateId?: number;

    /**
     * 期初人数
     */
    beginningCount?: number;

    /**
     * 入职人数
     */
    entryCount?: number;

    /**
     * 转正人数
     */
    regularCount?: number;

    /**
     * 转入
     */
    transferIn?: number;

    /**
     * 转出
     */
    transferOut?: number;

    /**
     * 试用期内
     */
    probationPeriod?: number;

    /**
     * 入职3年内
     */
    within3Years?: number;

    /**
     * 入职3年以上
     */
    over3Years?: number;

    /**
     * 被动离职
     */
    passiveResignation?: number;

    /**
     * 总离职
     */
    totalResignation?: number;

    /**
     * 期末人数
     */
    endingCount?: number;

    /**
     * 试用期内离职率
     */
    probationResignationRate?: number;

    /**
     * 入职3年内离职率
     */
    within3YearsResignationRate?: number;

    /**
     * 入职3年以上离职率
     */
    over3YearsResignationRate?: number;

    /**
     * 被动离职率
     */
    passiveResignationRate?: number;

    /**
     * 总离职率
     */
    totalResignationRate?: number;
  }
}

/**
 * 查询人员变化分析列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/employee/changeAnalysis/page', { params });
}
// /**
//  * 查询人员变化分析详细
//  * @param id
//  */
// export function apiDetail(id: number) {
//   return requestClient.get(`/hr/changeAnalysis/${id}`);
// }
// /**
//  * 新增人员变化分析
//  * @param data
//  */
// export function apiAdd(data: ChangeAnalysisApi.ChangeAnalysis) {
//   return requestClient.post('/hr/changeAnalysis', data);
// }
// /**
//  * 修改人员变化分析
//  * @param data
//  */
// export function apiUpdate(data: ChangeAnalysisApi.ChangeAnalysis) {
//   return requestClient.put('/hr/changeAnalysis', data);
// }
// /**
//  * 删除人员变化分析
//  * @param id
//  */
// export function apiDelete(id: Array<number> | number) {
//   return requestClient.delete(`/hr/changeAnalysis/${id}`);
// }
/**
 * 导出人员变化分析
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/employee/changeAnalysis/export', params);
}
