import type { VbenFormSchema } from '#/adapter/form';
import type { VxeTableGridOptions } from '#/adapter/vxe-table';
import type { ContractExpirationReminderApi } from '#/api/hr/contractExpirationReminder';

import { getDictOptions } from '#/utils/dict';

import { HrDictEnum } from '../dict-enum';

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'plate',
    label: '板块',
  },
  {
    component: 'Input',
    fieldName: 'firstLevelDepartment',
    label: '一级部门',
  },
  {
    component: 'Input',
    fieldName: 'secondLevelDepartment',
    label: '二级部门',
  },
  {
    component: 'Input',
    fieldName: 'thirdLevelDepartment',
    label: '三级部门',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'deptId',
  //   label: '部门ID',
  // },
  {
    component: 'Input',
    fieldName: 'position',
    label: '主岗位',
  },
  {
    component: 'Input',
    fieldName: 'name',
    label: '姓名',
  },
  {
    component: 'Input',
    fieldName: 'phoneNumber',
    label: '手机号码',
  },
  {
    component: 'RangePicker',
    fieldName: 'contractStartDate',
    label: '合同开始时间',
  },
  {
    component: 'RangePicker',
    fieldName: 'contractEndDate',
    label: '合同截止时间',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_CONTRACT_FORM),
    },
    fieldName: 'contractForm',
    label: '合同形式',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'remarks',
  //   label: '备注',
  // },
];

export function useColumns(): VxeTableGridOptions<ContractExpirationReminderApi.ContractExpirationReminder>['columns'] {
  return [
    {
      title: '板块',
      field: 'plate',
    },
    {
      title: '一级部门',
      field: 'firstLevelDepartment',
    },
    {
      title: '二级部门',
      field: 'secondLevelDepartment',
    },
    {
      title: '三级部门',
      field: 'thirdLevelDepartment',
    },
    // {
    //   title: '部门ID',
    //   field: 'deptId',
    // },
    {
      title: '主岗位',
      field: 'position',
    },
    {
      title: '姓名',
      field: 'name',
    },
    {
      title: '手机',
      field: 'phoneNumber',
    },
    {
      title: '劳动合同开始时间',
      field: 'contractStartDate',
      formatter: 'formatDate',
    },
    {
      title: '劳动合同截止时间',
      field: 'contractEndDate',
      formatter: 'formatDate',
    },
    {
      title: '合同形式',
      field: 'contractForm',
    },
    {
      title: '备注',
      field: 'remarks',
    },
    {
      align: 'right',
      slots: { default: 'action' },
      // cellRender: {
      //   attrs: {
      //     nameField: 'name',
      //     nameTitle: '员工合同续签提醒',
      //     onClick: onActionClick,
      //   },
      //   name: 'CellOperation',
      //   options: [
      //     {
      //       code: 'edit',
      //       accessCode: ['employee:contractExpirationReminder:edit'],
      //     }, // 默认的编辑按钮
      //     {
      //       code: 'delete',
      //       accessCode: ['employee:contractExpirationReminder:remove'],
      //     }, // 默认的删除按钮
      //   ],
      // },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
