import type { VxeGridProps } from '#/adapter/vxe-table';
import type { SysMenuApi } from '#/api/auth/menu';
import type { ID } from '#/api/baseModel';

import { h, markRaw } from 'vue';

import { FolderIcon, MenuIcon, OkButtonIcon } from '@vben/icons';

type MenuOption = SysMenuApi.MenuOption;

export interface Permission {
  checked: boolean;
  id: ID;
  label: string;
}

export interface MenuPermissionOption extends MenuOption {
  permissions: Permission[];
}

// const menuTypes = {
//   C: { icon: markRaw(MenuIcon), value: '菜单' },
//   F: { icon: markRaw(OkButtonIcon), value: '按钮' },
//   M: { icon: markRaw(FolderIcon), value: '目录' },
// };

const menuTypes = {
  0: { icon: markRaw(FolderIcon), value: '目录' },
  1: { icon: markRaw(MenuIcon), value: '菜单' },
  2: { icon: markRaw(OkButtonIcon), value: '按钮' },
};

export const nodeOptions = [
  { label: '节点关联', value: true },
  { label: '节点独立', value: false },
];

export const columns: VxeGridProps['columns'] = [
  {
    type: 'checkbox',
    title: '菜单名称',
    field: 'name',
    treeNode: true,
    headerAlign: 'left',
    align: 'left',
    width: 230,
  },
  // {
  //   title: '图标',
  //   field: 'icon',
  //   width: 80,
  //   slots: {
  //     default: ({ row }) => {
  //       if (row?.icon === '#') {
  //         return '';
  //       }
  //       return (
  //         <span class={'flex justify-center'}>
  //           <VbenIcon icon={row.icon} />
  //         </span>
  //       );
  //     },
  //   },
  // },
  {
    title: '类型',
    field: 'type',
    width: 80,
    slots: {
      default: ({ row }) => {
        const current = menuTypes[row.type as 0 | 1 | 2];
        if (!current) {
          return '未知';
        }
        return (
          <span class="flex items-center justify-center gap-1">
            {h(current.icon, { class: 'size-[18px]' })}
            <span>{current.value}</span>
          </span>
        );
      },
    },
  },
  {
    title: '权限标识',
    field: 'perms',
    headerAlign: 'left',
    align: 'left',
    slots: {
      default: 'permissions',
    },
  },
];
