import type { VbenFormSchema } from '#/adapter/form';
import type { VxeTableGridOptions } from '#/adapter/vxe-table';
import type { StaffingPlanDataApi } from '#/api/hr/staffingPlanData';
import type { StaffingPlanRecordsApi } from '#/api/hr/staffingPlanRecords';

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'plate',
    label: '板块',
  },
  {
    component: 'Input',
    fieldName: 'firstLevelDepartment',
    label: '一级部门',
  },
  {
    component: 'Input',
    fieldName: 'secondLevelDepartment',
    label: '二级部门',
  },
  {
    component: 'Input',
    fieldName: 'thirdLevelDepartment',
    label: '三级部门',
  },
  {
    component: 'Input',
    fieldName: 'deptId',
    label: '部门ID',
  },
  {
    component: 'Input',
    fieldName: 'position',
    label: '主岗位',
  },
  {
    component: 'Input',
    fieldName: 'lastYearStaffing',
    label: '上一年编制',
  },
  {
    component: 'Input',
    fieldName: 'thisYearStaffing',
    label: '今年编制',
  },
  {
    component: 'Input',
    fieldName: 'nextYearStaffing',
    label: '下一年编制',
  },
  {
    component: 'Input',
    fieldName: 'm1FormalPlan',
    label: '1月正式工计划',
  },
  {
    component: 'Input',
    fieldName: 'm1FormalActual',
    label: '1月正式工实际',
  },
  {
    component: 'Input',
    fieldName: 'm1PartPlan',
    label: '1月兼职计划',
  },
  {
    component: 'Input',
    fieldName: 'm1PartActual',
    label: '1月兼职实际',
  },
  {
    component: 'Input',
    fieldName: 'm2FormalPlan',
    label: '2月正式工计划',
  },
  {
    component: 'Input',
    fieldName: 'm2FormalActual',
    label: '2月正式工实际',
  },
  {
    component: 'Input',
    fieldName: 'm2PartPlan',
    label: '2月兼职计划',
  },
  {
    component: 'Input',
    fieldName: 'm2PartActual',
    label: '2月兼职实际',
  },
  {
    component: 'Input',
    fieldName: 'm3FormalPlan',
    label: '3月正式工计划',
  },
  {
    component: 'Input',
    fieldName: 'm3FormalActual',
    label: '3月正式工实际',
  },
  {
    component: 'Input',
    fieldName: 'm3PartPlan',
    label: '3月兼职计划',
  },
  {
    component: 'Input',
    fieldName: 'm3PartActual',
    label: '3月兼职实际',
  },
  {
    component: 'Input',
    fieldName: 'm4FormalPlan',
    label: '4月正式工计划',
  },
  {
    component: 'Input',
    fieldName: 'm4FormalActual',
    label: '4月正式工实际',
  },
  {
    component: 'Input',
    fieldName: 'm4PartPlan',
    label: '4月兼职计划',
  },
  {
    component: 'Input',
    fieldName: 'm4PartActual',
    label: '4月兼职实际',
  },
  {
    component: 'Input',
    fieldName: 'm5FormalPlan',
    label: '5月正式工计划',
  },
  {
    component: 'Input',
    fieldName: 'm5FormalActual',
    label: '5月正式工实际',
  },
  {
    component: 'Input',
    fieldName: 'm5PartPlan',
    label: '5月兼职计划',
  },
  {
    component: 'Input',
    fieldName: 'm5PartActual',
    label: '5月兼职实际',
  },
  {
    component: 'Input',
    fieldName: 'm6FormalPlan',
    label: '6月正式工计划',
  },
  {
    component: 'Input',
    fieldName: 'm6FormalActual',
    label: '6月正式工实际',
  },
  {
    component: 'Input',
    fieldName: 'm6PartPlan',
    label: '6月兼职计划',
  },
  {
    component: 'Input',
    fieldName: 'm6PartActual',
    label: '6月兼职实际',
  },
  {
    component: 'Input',
    fieldName: 'm7FormalPlan',
    label: '7月正式工计划',
  },
  {
    component: 'Input',
    fieldName: 'm7FormalActual',
    label: '7月正式工实际',
  },
  {
    component: 'Input',
    fieldName: 'm7PartPlan',
    label: '7月兼职计划',
  },
  {
    component: 'Input',
    fieldName: 'm7PartActual',
    label: '7月兼职实际',
  },
  {
    component: 'Input',
    fieldName: 'm8FormalPlan',
    label: '8月正式工计划',
  },
  {
    component: 'Input',
    fieldName: 'm8FormalActual',
    label: '8月正式工实际',
  },
  {
    component: 'Input',
    fieldName: 'm8PartPlan',
    label: '8月兼职计划',
  },
  {
    component: 'Input',
    fieldName: 'm8PartActual',
    label: '8月兼职实际',
  },
  {
    component: 'Input',
    fieldName: 'm9FormalPlan',
    label: '9月正式工计划',
  },
  {
    component: 'Input',
    fieldName: 'm9FormalActual',
    label: '9月正式工实际',
  },
  {
    component: 'Input',
    fieldName: 'm9PartPlan',
    label: '9月兼职计划',
  },
  {
    component: 'Input',
    fieldName: 'm9PartActual',
    label: '9月兼职实际',
  },
  {
    component: 'Input',
    fieldName: 'm10FormalPlan',
    label: '10月正式工计划',
  },
  {
    component: 'Input',
    fieldName: 'm10FormalActual',
    label: '10月正式工实际',
  },
  {
    component: 'Input',
    fieldName: 'm10PartPlan',
    label: '10月兼职计划',
  },
  {
    component: 'Input',
    fieldName: 'm10PartActual',
    label: '10月兼职实际',
  },
  {
    component: 'Input',
    fieldName: 'm11FormalPlan',
    label: '11月正式工计划',
  },
  {
    component: 'Input',
    fieldName: 'm11FormalActual',
    label: '11月正式工实际',
  },
  {
    component: 'Input',
    fieldName: 'm11PartPlan',
    label: '11月兼职计划',
  },
  {
    component: 'Input',
    fieldName: 'm11PartActual',
    label: '11月兼职实际',
  },
  {
    component: 'Input',
    fieldName: 'm12FormalPlan',
    label: '12月正式工计划',
  },
  {
    component: 'Input',
    fieldName: 'm12FormalActual',
    label: '12月正式工实际',
  },
  {
    component: 'Input',
    fieldName: 'm12PartPlan',
    label: '12月兼职计划',
  },
  {
    component: 'Input',
    fieldName: 'm12PartActual',
    label: '12月兼职实际',
  },
  {
    component: 'Input',
    fieldName: 'summary',
    label: '合计行',
  },
];

export function useColumns(
  staffingPlanRecords: StaffingPlanRecordsApi.StaffingPlanRecords,
): VxeTableGridOptions<StaffingPlanDataApi.StaffingPlanData>['columns'] {
  // console.log(
  //   '[staffingPlanRecords]',
  //   // staffingPlanRecords,
  //   staffingPlanRecords.currentYearTitle,
  // );
  return [
    {
      title: '板块',
      field: 'plate',
      width: 100,
    },
    {
      title: '一级部门',
      field: 'firstLevelDepartment',
      width: 100,
    },
    {
      title: '二级部门',
      field: 'secondLevelDepartment',
      width: 100,
    },
    {
      title: '三级部门',
      field: 'thirdLevelDepartment',
      width: 100,
    },
    // {
    //   title: '部门ID',
    //   field: 'deptId',
    // },
    {
      title: '岗位名称',
      field: 'position',
      width: 100,
    },
    {
      title: staffingPlanRecords.lastYearTitle || '上一年编制',
      field: 'lastYearStaffing',
      width: 100,
    },
    {
      title: staffingPlanRecords.currentYearTitle || '今年编制',
      field: 'thisYearStaffing',
      width: 100,
    },
    {
      title: staffingPlanRecords.nextYearTitle || '下一年编制',
      field: 'nextYearStaffing',
      width: 100,
      editRender: { name: 'input', attrs: { type: 'number' } },
    },
    {
      title: staffingPlanRecords.nextYearTitle || '下一年编制',
      headerAlign: 'center',
      children: [
        {
          title: '1月正式工计划',
          field: 'm1FormalPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '1月正式工实际',
          field: 'm1FormalActual',
          width: 100,
        },
        {
          title: '1月兼职计划',
          field: 'm1PartPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '1月兼职实际',
          field: 'm1PartActual',
          width: 100,
        },
        {
          title: '2月正式工计划',
          field: 'm2FormalPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '2月正式工实际',
          field: 'm2FormalActual',
          width: 100,
        },
        {
          title: '2月兼职计划',
          field: 'm2PartPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '2月兼职实际',
          field: 'm2PartActual',
          width: 100,
        },
        {
          title: '3月正式工计划',
          field: 'm3FormalPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '3月正式工实际',
          field: 'm3FormalActual',
          width: 100,
        },
        {
          title: '3月兼职计划',
          field: 'm3PartPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '3月兼职实际',
          field: 'm3PartActual',
          width: 100,
        },
        {
          title: '4月正式工计划',
          field: 'm4FormalPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '4月正式工实际',
          field: 'm4FormalActual',
          width: 100,
        },
        {
          title: '4月兼职计划',
          field: 'm4PartPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '4月兼职实际',
          field: 'm4PartActual',
          width: 100,
        },
        {
          title: '5月正式工计划',
          field: 'm5FormalPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '5月正式工实际',
          field: 'm5FormalActual',
          width: 100,
        },
        {
          title: '5月兼职计划',
          field: 'm5PartPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '5月兼职实际',
          field: 'm5PartActual',
          width: 100,
        },
        {
          title: '6月正式工计划',
          field: 'm6FormalPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '6月正式工实际',
          field: 'm6FormalActual',
          width: 100,
        },
        {
          title: '6月兼职计划',
          field: 'm6PartPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '6月兼职实际',
          field: 'm6PartActual',
          width: 100,
        },
        {
          title: '7月正式工计划',
          field: 'm7FormalPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '7月正式工实际',
          field: 'm7FormalActual',
          width: 100,
        },
        {
          title: '7月兼职计划',
          field: 'm7PartPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '7月兼职实际',
          field: 'm7PartActual',
          width: 100,
        },
        {
          title: '8月正式工计划',
          field: 'm8FormalPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '8月正式工实际',
          field: 'm8FormalActual',
          width: 100,
        },
        {
          title: '8月兼职计划',
          field: 'm8PartPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '8月兼职实际',
          field: 'm8PartActual',
          width: 100,
        },
        {
          title: '9月正式工计划',
          field: 'm9FormalPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '9月正式工实际',
          field: 'm9FormalActual',
          width: 100,
        },
        {
          title: '9月兼职计划',
          field: 'm9PartPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '9月兼职实际',
          field: 'm9PartActual',
          width: 100,
        },
        {
          title: '10月正式工计划',
          field: 'm10FormalPlan',
          width: 130,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '10月正式工实际',
          field: 'm10FormalActual',
          width: 110,
        },
        {
          title: '10月兼职计划',
          field: 'm10PartPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '10月兼职实际',
          field: 'm10PartActual',
          width: 100,
        },
        {
          title: '11月正式工计划',
          field: 'm11FormalPlan',
          width: 130,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '11月正式工实际',
          field: 'm11FormalActual',
          width: 110,
        },
        {
          title: '11月兼职计划',
          field: 'm11PartPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '11月兼职实际',
          field: 'm11PartActual',
          width: 100,
        },
        {
          title: '12月正式工计划',
          field: 'm12FormalPlan',
          width: 130,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '12月正式工实际',
          field: 'm12FormalActual',
          width: 110,
        },
        {
          title: '12月兼职计划',
          field: 'm12PartPlan',
          width: 120,
          editRender: { name: 'input', attrs: { type: 'number' } },
        },
        {
          title: '12月兼职实际',
          field: 'm12PartActual',
          width: 100,
        },
      ],
    },
    // {
    //   title: '合计行',
    //   field: 'summary',
    //   width: 100,
    // },
    {
      title: '备注',
      field: 'remark',
      width: 100,
    },
    // {
    //   align: 'right',
    //   cellRender: {
    //     attrs: {
    //       nameField: 'name',
    //       nameTitle: '编制规划记录明细',
    //       onClick: onActionClick,
    //     },
    //     name: 'CellOperation',
    //     options: [
    //       {
    //         code: 'edit',
    //         accessCode: ['employee:staffingPlanData:edit'],
    //       }, // 默认的编辑按钮
    //       {
    //         code: 'delete',
    //         accessCode: ['employee:staffingPlanData:remove'],
    //       }, // 默认的删除按钮
    //     ],
    //   },
    //   field: 'action',
    //   fixed: 'right',
    //   headerAlign: 'center',
    //   resizable: false,
    //   showOverflow: false,
    //   title: '操作',
    //   width: 'auto',
    // },
  ];
}
