import type { VbenFormSchema } from '#/adapter/form';
import type { VxeTableGridOptions } from '#/adapter/vxe-table';
import type { PartTimeInfoApi } from '#/api/hr/partTimeInfo';

export const querySchema: VbenFormSchema[] = [
  // {
  //   component: 'Input',
  //   fieldName: 'plate',
  //   label: '板块',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'firstLevelDepartment',
  //   label: '一级部门',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'secondLevelDepartment',
  //   label: '二级部门',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'thirdLevelDepartment',
  //   label: '三级部门',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'deptId',
  //   label: '部门ID',
  // },
  {
    component: 'Input',
    fieldName: 'position',
    label: '主岗位',
  },
  {
    component: 'Input',
    fieldName: 'name',
    label: '姓名',
  },
  {
    component: 'Input',
    fieldName: 'gender',
    label: '性别',
  },
  {
    component: 'Input',
    fieldName: 'idCardNumber',
    label: '身份证号码',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'ossId',
  //   label: '照片ID',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'birthDate',
  //   label: '出生日期',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'age',
  //   label: '年龄',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'nativePlace',
  //   label: '籍贯',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'ethnicity',
  //   label: '民族',
  // },
  {
    component: 'Input',
    fieldName: 'phoneNumber',
    label: '手机号码',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'emergencyContact',
  //   label: '紧急联系人',
  // },
  {
    component: 'Input',
    fieldName: 'emergencyContactPhone',
    label: '紧急联系人电话',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'homeAddress',
  //   label: '家庭地址',
  // },
  {
    component: 'DatePicker',
    fieldName: 'entryDate',
    label: '入职时间',
  },
  {
    component: 'Input',
    fieldName: 'fulltimeEducation',
    label: '全日制学历',
  },
  {
    component: 'Input',
    fieldName: 'fulltimeSchool',
    label: '全日制毕业院校',
  },
  {
    component: 'Input',
    fieldName: 'fulltimeMajor',
    label: '全日制专业',
  },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'fulltimeGraduationDate',
  //   label: '全日制毕业日期',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'fulltimeDegree',
  //   label: '全日制学位',
  // },
  {
    component: 'Input',
    fieldName: 'employmentForm',
    label: '用工形式',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'partTimeFlag',
  //   label: '是否兼职',
  // },
  {
    component: 'Input',
    fieldName: 'partTimeAgreement',
    label: '签订兼职协议',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'agreementEntity',
  //   label: '协议主体',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'agreementPeriod',
  //   label: '协议期限',
  // },
  {
    component: 'DatePicker',
    fieldName: 'agreementStartDate',
    label: '协议开始时间',
  },
  {
    component: 'DatePicker',
    fieldName: 'agreementEndDate',
    label: '协议截止时间',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'remarks',
  //   label: '备注',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'bankCardNumber',
  //   label: '银行卡号',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'bankName',
  //   label: '开户行',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'hasRelativeInCompany',
  //   label: '公司内是否有亲属关系',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'relativeName',
  //   label: '亲属姓名',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'introducer',
  //   label: '介绍人',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'introducerRelation',
  //   label: '介绍人关系',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'salaryLocation',
  //   label: '工资发放地',
  // },
  {
    component: 'Input',
    fieldName: 'costOfDept',
    label: '成本费用所属',
  },
];

export function useColumns(): VxeTableGridOptions<PartTimeInfoApi.PartTimeInfo>['columns'] {
  return [
    { title: '序号', type: 'seq', width: 50 },
    {
      title: '板块',
      field: 'plate',
      width: 80,
    },
    {
      title: '一级部门',
      field: 'firstLevelDepartment',
      width: 90,
    },
    {
      title: '二级部门',
      field: 'secondLevelDepartment',
      width: 100,
    },
    {
      title: '三级部门',
      field: 'thirdLevelDepartment',
      width: 120,
    },
    // {
    //   title: '部门ID',
    //   field: 'deptId',
    // },
    {
      title: '岗位类型',
      field: 'positionTypeName',
      width: 100,
      // cellRender: { name: 'CellTag', options: [getTagDicts(DictEnum.HR_POSITION_TYPE)] },
    },
    {
      title: '主岗位',
      field: 'positionName',
      width: 100,
    },
    {
      title: '姓名',
      field: 'name',
      width: 100,
    },
    {
      title: '性别',
      field: 'genderName',
      width: 80,
    },
    {
      title: '身份证号码',
      field: 'idCardNumber',
      width: 130,
    },
    // {
    //   title: '照片ID',
    //   field: 'ossId',
    // },
    {
      title: '出生日期',
      field: 'birthDate',
      // formatter: 'formatDate',
      width: 100,
    },
    {
      title: '年龄',
      field: 'age',
      width: 80,
    },
    {
      title: '籍贯',
      field: 'nativePlace',
      width: 120,
    },
    {
      title: '民族',
      field: 'ethnicity',
      width: 80,
    },
    {
      title: '婚姻状况',
      field: 'maritalStatusName',
      width: 80,
    },
    {
      title: '政治面貌',
      field: 'politicalStatusName',
      width: 80,
    },
    {
      title: '手机号码',
      field: 'phoneNumber',
      width: 110,
    },
    {
      title: '紧急联系人',
      field: 'emergencyContact',
      width: 100,
    },
    {
      title: '紧急联系人电话',
      field: 'emergencyContactPhone',
      width: 110,
    },
    {
      title: '家庭地址',
      field: 'homeAddress',
      width: 120,
    },
    {
      title: '入职时间',
      field: 'entryDate',
      // formatter: 'formatDate',
      width: 100,
    },
    {
      title: '全日制学历',
      field: 'fulltimeEducation',
      width: 100,
    },
    {
      title: '全日制毕业院校',
      field: 'fulltimeSchool',
      width: 100,
    },
    {
      title: '全日制专业',
      field: 'fulltimeMajor',
      width: 90,
    },
    {
      title: '全日制毕业日期',
      field: 'fulltimeGraduationDate',
      // formatter: 'formatDate',
      width: 100,
    },
    {
      title: '全日制学位',
      field: 'fulltimeDegree',
      width: 100,
    },
    {
      title: '用工形式',
      field: 'employmentFormName',
      width: 100,
    },
    // {
    //   title: '是否兼职',
    //   field: 'partTimeFlag',
    // },
    {
      title: '签订兼职协议',
      field: 'partTimeAgreement',
      width: 100,
    },
    {
      title: '协议主体',
      field: 'agreementEntity',
      width: 80,
    },
    {
      title: '协议期限',
      field: 'agreementPeriod',
      width: 80,
    },
    {
      title: '协议开始时间',
      field: 'agreementStartDate',
      width: 100,
      // formatter: 'formatDateTime',
    },
    {
      title: '协议截止时间',
      field: 'agreementEndDate',
      width: 100,
      // formatter: 'formatDateTime',
    },
    {
      title: '银行卡号',
      field: 'bankCardNumber',
      width: 110,
    },
    {
      title: '开户行',
      field: 'bankName',
      width: 110,
    },
    {
      title: '公司内是否有亲属关系',
      field: 'hasRelativeInCompanyName',
      width: 90,
    },
    {
      title: '亲属姓名',
      field: 'relativeName',
      width: 90,
    },
    {
      title: '介绍人',
      field: 'introducer',
      width: 90,
    },
    {
      title: '介绍人关系',
      field: 'introducerRelation',
      width: 90,
    },
    {
      title: '工资发放地',
      field: 'salaryLocation',
      width: 100,
    },
    {
      title: '成本费用所属',
      field: 'costOfDept',
      width: 110,
    },
    // {
    //   title: '备注',
    //   field: 'remarks',
    // },
    {
      align: 'right',
      slots: { default: 'action' },
      // cellRender: {
      //   attrs: {
      //     nameField: 'name',
      //     nameTitle: '兼职员工信息',
      //     onClick: onActionClick,
      //   },
      //   name: 'CellOperation',
      //   options: [
      //     {
      //       code: 'edit',
      //       accessCode: ['employee:partTimeInfo:edit'],
      //     }, // 默认的编辑按钮
      //     {
      //       code: 'delete',
      //       accessCode: ['employee:partTimeInfo:remove'],
      //     }, // 默认的删除按钮
      //   ],
      // },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
