import type { VbenFormSchema } from '#/adapter/form';
import type { VxeTableGridOptions } from '#/adapter/vxe-table';
import type { EmployeeInfoApi } from '#/api/hr/employeeModel';

import { getDictOptions } from '#/utils/dict';

import { HrDictEnum } from '../dict-enum';

export const querySchema: VbenFormSchema[] = [
  // {
  //   component: 'Input',
  //   fieldName: 'plate',
  //   label: '板块',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'firstLevelDepartment',
  //   label: '一级部门',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'secondLevelDepartment',
  //   label: '二级部门',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'thirdLevelDepartment',
  //   label: '三级部门',
  // },
  {
    component: 'Input',
    fieldName: 'employeeNo',
    label: '工号',
  },
  {
    component: 'Input',
    fieldName: 'jobLevel',
    label: '职级',
  },
  {
    component: 'Input',
    fieldName: 'position',
    label: '岗位',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_SEQUENCE),
    },
    fieldName: 'sequence',
    label: '序列',
  },
  {
    component: 'Input',
    fieldName: 'name',
    label: '姓名',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_USER_SEX),
    },
    fieldName: 'gender',
    label: '性别',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'idCardNumber',
  //   label: '身份证号码',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'birthDate',
  //   label: '出生日期',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'age',
  //   label: '年龄',
  // },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_AGE_GROUP),
    },
    fieldName: 'ageGroup',
    label: '年龄段',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'nativePlace',
  //   label: '籍贯',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'ethnicity',
  //   label: '民族',
  // },
  {
    component: 'Input',
    fieldName: 'phoneNumber',
    label: '手机号码',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'emergencyContact',
  //   label: '紧急联系人',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'emergencyContactPhone',
  //   label: '紧急联系人电话',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'homeAddress',
  //   label: '家庭地址',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'householdRegistrationAddress',
  //   label: '户口所在地',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'workStartDate',
  //   label: '参加工作',
  // },
  {
    component: 'RangePicker',
    fieldName: 'entryDate',
    label: '入职时间',
    componentProps: {
      valueFormat: 'YYYY-MM-DD',
    },
  },
  // {
  //   component: 'Input',
  //   fieldName: 'yearsOfService',
  //   label: '工龄',
  // },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_YEARS_SERVICE_SEGMENT),
    },
    fieldName: 'yearsOfServiceSegment',
    label: '工龄段',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_MARITAL_STATUS),
    },
    fieldName: 'maritalStatus',
    label: '婚姻状况',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_POLITICAL_STATUS),
    },
    fieldName: 'politicalStatus',
    label: '政治面貌',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_EDUCATION_CATEGORY),
    },
    fieldName: 'educationCategory',
    label: '学历分类',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'fulltimeEducation',
  //   label: '学历',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'degree',
  //   label: '学位',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'graduationDate',
  //   label: '毕业时间',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'major',
  //   label: '专业',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'graduateSchool',
  //   label: '毕业院校',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'professionalTitle',
  //   label: '职称情况',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'resume',
  //   label: '简历',
  // },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_EMPLOYMENT_FORM),
    },
    fieldName: 'employmentForm',
    label: '用工形式',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'contractTerm',
  //   label: '劳动合同期限',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'contractStartDate',
  //   label: '劳动合同开始时间',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'contractEndDate',
  //   label: '劳动合同截止时间',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'contractExpirationReminder',
  //   label: '合同到期提醒',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'contractEntity',
  //   label: '合同主体',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'regularizationDate',
  //   label: '转正时间',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'remarks',
  //   label: '备注',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'resignationDate',
  //   label: '离职时间',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'resignationReason',
  //   label: '离职原因',
  // },
];

export function useColumns(): VxeTableGridOptions<EmployeeInfoApi.Employee>['columns'] {
  // onActionClick: OnActionClickFn<EmployeeInfoApi.Employee>,
  return [
    { title: '序号', type: 'seq', width: 50 },
    {
      title: '板块',
      field: 'plate',
      width: 80,
    },
    {
      title: '一级部门',
      field: 'firstLevelDepartment',
      width: 90,
    },
    {
      title: '二级部门',
      field: 'secondLevelDepartment',
      width: 100,
    },
    {
      title: '三级部门',
      field: 'thirdLevelDepartment',
      width: 120,
    },
    {
      title: '工号',
      field: 'employeeNo',
      width: 80,
    },
    {
      title: '职级',
      field: 'jobLevel',
      width: 80,
    },
    {
      title: '岗位类型',
      field: 'positionTypeName',
      width: 100,
      // cellRender: { name: 'CellTag', options: [getTagDicts(DictEnum.HR_POSITION_TYPE)] },
    },
    {
      title: '序列',
      field: 'sequenceName',
      width: 80,
    },
    {
      title: '主岗位',
      field: 'position',
      width: 100,
    },
    {
      title: '姓名',
      field: 'name',
      width: 100,
    },
    {
      title: '性别',
      field: 'genderName',
      width: 80,
    },
    {
      title: '身份证号码',
      field: 'idCardNumber',
      width: 120,
    },
    {
      title: '出生日期',
      field: 'birthDate',
      // formatter: 'formatDate',
      width: 100,
    },
    {
      title: '年龄',
      field: 'age',
      width: 80,
    },
    {
      title: '年龄段',
      field: 'ageGroupName',
      width: 100,
    },
    {
      title: '兼岗板块',
      field: 'concurrentPlate',
      width: 80,
    },
    {
      title: '兼岗一级部门',
      field: 'concurrentFirstDept',
      width: 90,
    },
    {
      title: '兼岗二级部门',
      field: 'concurrentSecondDept',
      width: 100,
    },
    {
      title: '兼岗三级部门',
      field: 'concurrentThirdDept',
      width: 120,
    },
    {
      title: '兼岗岗位',
      field: 'concurrentPosition',
      width: 100,
    },
    {
      title: '兼岗岗位类型',
      field: 'concurrentPositionTypeName',
      width: 100,
    },
    {
      title: '籍贯',
      field: 'nativePlace',
      width: 120,
    },
    {
      title: '民族',
      field: 'ethnicity',
      width: 80,
    },
    {
      title: '婚姻状况',
      field: 'maritalStatusName',
      width: 80,
    },
    {
      title: '政治面貌',
      field: 'politicalStatusName',
      width: 80,
    },
    {
      title: '手机号码',
      field: 'phoneNumber',
      width: 110,
    },
    {
      title: '紧急联系人',
      field: 'emergencyContact',
      width: 100,
    },
    {
      title: '紧急联系人电话',
      field: 'emergencyContactPhone',
      width: 110,
    },
    {
      title: '家庭地址',
      field: 'homeAddress',
      width: 120,
    },
    {
      title: '户口所在地',
      field: 'householdRegistrationAddress',
      width: 120,
    },
    {
      title: '参加工作时间',
      field: 'workStartDate',
      // formatter: 'formatDate',
      width: 100,
    },
    {
      title: '入职时间',
      field: 'entryDate',
      // formatter: 'formatDate',
      width: 100,
    },
    {
      title: '工龄',
      field: 'yearsOfService',
      width: 90,
    },
    {
      title: '工龄段',
      field: 'yearsOfServiceSegmentName',
      width: 90,
    },
    {
      title: '全日制学历',
      field: 'fulltimeEducation',
      width: 100,
    },
    {
      title: '全日制毕业院校',
      field: 'fulltimeSchool',
      width: 100,
    },
    {
      title: '全日制专业',
      field: 'fulltimeMajor',
      width: 90,
    },
    {
      title: '全日制毕业日期',
      field: 'fulltimeGraduationDate',
      // formatter: 'formatDate',
      width: 100,
    },
    {
      title: '全日制学位',
      field: 'fulltimeDegree',
      width: 100,
    },
    {
      title: '非全日制学历',
      field: 'nonFulltimeEducation',
      width: 100,
    },
    {
      title: '非全日制毕业院校',
      field: 'nonFulltimeSchool',
      width: 100,
    },
    {
      title: '非全日制专业',
      field: 'nonFulltimeMajor',
      width: 90,
    },
    {
      title: '非全日制毕业日期',
      field: 'nonFulltimeGraduationDate',
      // formatter: 'formatDate',
      width: 100,
    },
    {
      title: '非全日制学位',
      field: 'nonFulltimeDegree',
      width: 100,
    },
    {
      title: '学历分类',
      field: 'educationCategoryName',
      width: 90,
    },
    {
      title: '员工类型',
      field: 'employeeTypeName',
      width: 90,
    },
    {
      title: '职称情况',
      field: 'professionalTitle',
      width: 90,
    },
    {
      title: '证书情况',
      field: 'certificateStatusName',
      width: 100,
    },
    {
      title: '外部个人履历',
      field: 'externalResume',
      width: 120,
    },
    {
      title: '内部个人履历',
      field: 'internalResume',
      width: 120,
    },
    {
      title: '用工形式',
      field: 'employmentFormName',
      width: 100,
    },
    {
      title: '合同形式',
      field: 'contractFormName',
      width: 100,
    },
    {
      title: '劳动合同期限',
      field: 'contractTerm',
      width: 80,
    },
    {
      title: '劳动合同开始时间',
      field: 'contractStartDate',
      // formatter: 'formatDate',
      width: 100,
    },
    {
      title: '劳动合同截止时间',
      field: 'contractEndDate',
      // formatter: 'formatDate',
      width: 100,
    },
    {
      title: '合同到期提醒',
      field: 'contractExpirationReminder',
      // formatter: 'formatDate',
      width: 100,
    },
    {
      title: '劳动合同签订情况',
      field: 'contractSigningStatus',
      width: 110,
    },
    {
      title: '合同主体',
      field: 'contractEntity',
      width: 90,
    },
    {
      title: '社保主体',
      field: 'socialSecurityEntity',
      width: 90,
    },
    {
      title: '是否缴纳社保',
      field: 'hasSocialSecurityPaidName',
      width: 90,
    },
    {
      title: '公积金主体',
      field: 'providentFundEntity',
      width: 90,
    },
    {
      title: '是否缴纳公积金',
      field: 'hasProvidentFundPaidName',
      width: 90,
    },
    {
      title: '是否缴纳雇主险',
      field: 'hasEmployerInsurancePaidName',
      width: 90,
    },
    {
      title: '试用期',
      field: 'probationPeriod',
      width: 90,
    },
    {
      title: '转正时间',
      field: 'regularizationDate',
      // formatter: 'formatDate',
      width: 100,
    },
    {
      title: '预计转正时间',
      field: 'expectedRegularDate',
      // formatter: 'formatDate',
      width: 100,
    },
    {
      title: '奖励情况',
      field: 'rewardStatusName',
      width: 110,
    },
    {
      title: '处罚情况',
      field: 'punishmentStatusName',
      width: 110,
    },
    {
      title: '备注',
      field: 'remarks',
      width: 110,
    },
    {
      title: '办公电话',
      field: 'officePhone',
      width: 110,
    },
    {
      title: '短线',
      field: 'shortLine',
      width: 90,
    },
    {
      title: '银行卡号',
      field: 'bankCardNumber',
      width: 110,
    },
    {
      title: '开户行',
      field: 'bankName',
      width: 110,
    },
    {
      title: '公司内是否有亲属关系',
      field: 'hasRelativeInCompanyName',
      width: 90,
    },
    {
      title: '亲属姓名',
      field: 'relativeName',
      width: 90,
    },
    {
      title: '介绍人',
      field: 'introducer',
      width: 90,
    },
    {
      title: '介绍人关系',
      field: 'introducerRelation',
      width: 90,
    },
    {
      title: '工资发放地',
      field: 'salaryLocation',
      width: 100,
    },
    {
      title: '编制所在地',
      field: 'staffingLocation',
      width: 100,
    },
    {
      title: '成本费用所属',
      field: 'costOfDept',
      width: 110,
    },
    {
      title: '成本费用细分',
      field: 'costType',
      width: 110,
      // cellRender: { name: 'CellTag', options: [getTagDicts()] },
    },
    {
      title: '绩效比例',
      field: 'performanceRatio',
      width: 100,
    },
    {
      title: '工装',
      field: 'workwearDetail',
      width: 110,
    },
    {
      title: '内部购房优惠',
      field: 'internalPurchaseDiscountsName',
      width: 110,
    },
    {
      title: '安泰业主',
      field: 'antaiHomeownersName',
      width: 80,
    },
    {
      title: '小区具体信息',
      field: 'antaiCommunityInfo',
      width: 110,
    },
    {
      align: 'right',
      slots: { default: 'action' },
      // cellRender: {
      //   attrs: {
      //     nameField: 'name',
      //     nameTitle: '员工信息',
      //     onClick: onActionClick,
      //   },
      //   name: 'CellOperation',
      //   options: [
      //     {
      //       code: 'export',
      //       text: '导出简历',
      //       // disabled: (row: SysUserApi.User) => {
      //       //   return !!(row.id === 1);
      //       // },
      //       accessCode: ['employee:info:export'],
      //     },
      //     {
      //       code: 'edit',
      //       accessCode: ['employee:info:edit'],
      //     }, // 默认的编辑按钮
      //     {
      //       code: 'delete',
      //       text: '离职',
      //       accessCode: ['employee:info:remove'],
      //     }, // 默认的删除按钮
      //   ],
      // },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
