import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace StaffingPlanDataApi {
  export interface StaffingPlanData extends BaseModel {
    /**
     * 板块
     */
    plate?: string;
    /**
     * 一级部门
     */
    firstLevelDepartment?: string;
    /**
     * 二级部门
     */
    secondLevelDepartment?: string;
    /**
     * 三级部门
     */
    thirdLevelDepartment?: string;
    /**
     * 部门ID
     */
    deptId?: number;

    /**
     * 主岗位
     */
    position?: string;
    /**
     * 上一年编制
     */
    lastYearStaffing?: number;

    /**
     * 今年编制
     */
    thisYearStaffing?: number;

    /**
     * 下一年编制
     */
    nextYearStaffing?: number;

    /**
     * 1月正式工计划
     */
    m1FormalPlan?: number;

    /**
     * 1月正式工实际
     */
    m1FormalActual?: string;
    /**
     * 1月兼职计划
     */
    m1PartPlan?: number;

    /**
     * 1月兼职实际
     */
    m1PartActual?: string;
    /**
     * 2月正式工计划
     */
    m2FormalPlan?: number;

    /**
     * 2月正式工实际
     */
    m2FormalActual?: string;
    /**
     * 2月兼职计划
     */
    m2PartPlan?: number;

    /**
     * 2月兼职实际
     */
    m2PartActual?: string;
    /**
     * 3月正式工计划
     */
    m3FormalPlan?: number;

    /**
     * 3月正式工实际
     */
    m3FormalActual?: string;
    /**
     * 3月兼职计划
     */
    m3PartPlan?: number;

    /**
     * 3月兼职实际
     */
    m3PartActual?: string;
    /**
     * 4月正式工计划
     */
    m4FormalPlan?: number;

    /**
     * 4月正式工实际
     */
    m4FormalActual?: string;
    /**
     * 4月兼职计划
     */
    m4PartPlan?: number;

    /**
     * 4月兼职实际
     */
    m4PartActual?: string;
    /**
     * 5月正式工计划
     */
    m5FormalPlan?: number;

    /**
     * 5月正式工实际
     */
    m5FormalActual?: string;
    /**
     * 5月兼职计划
     */
    m5PartPlan?: number;

    /**
     * 5月兼职实际
     */
    m5PartActual?: string;
    /**
     * 6月正式工计划
     */
    m6FormalPlan?: number;

    /**
     * 6月正式工实际
     */
    m6FormalActual?: string;
    /**
     * 6月兼职计划
     */
    m6PartPlan?: number;

    /**
     * 6月兼职实际
     */
    m6PartActual?: string;
    /**
     * 7月正式工计划
     */
    m7FormalPlan?: number;

    /**
     * 7月正式工实际
     */
    m7FormalActual?: string;
    /**
     * 7月兼职计划
     */
    m7PartPlan?: number;

    /**
     * 7月兼职实际
     */
    m7PartActual?: string;
    /**
     * 8月正式工计划
     */
    m8FormalPlan?: number;

    /**
     * 8月正式工实际
     */
    m8FormalActual?: string;
    /**
     * 8月兼职计划
     */
    m8PartPlan?: number;

    /**
     * 8月兼职实际
     */
    m8PartActual?: string;
    /**
     * 9月正式工计划
     */
    m9FormalPlan?: number;

    /**
     * 9月正式工实际
     */
    m9FormalActual?: string;
    /**
     * 9月兼职计划
     */
    m9PartPlan?: number;

    /**
     * 9月兼职实际
     */
    m9PartActual?: string;
    /**
     * 10月正式工计划
     */
    m10FormalPlan?: number;

    /**
     * 10月正式工实际
     */
    m10FormalActual?: string;
    /**
     * 10月兼职计划
     */
    m10PartPlan?: number;

    /**
     * 10月兼职实际
     */
    m10PartActual?: string;
    /**
     * 11月正式工计划
     */
    m11FormalPlan?: number;

    /**
     * 11月正式工实际
     */
    m11FormalActual?: string;
    /**
     * 11月兼职计划
     */
    m11PartPlan?: number;

    /**
     * 11月兼职实际
     */
    m11PartActual?: string;
    /**
     * 12月正式工计划
     */
    m12FormalPlan?: number;

    /**
     * 12月正式工实际
     */
    m12FormalActual?: string;
    /**
     * 12月兼职计划
     */
    m12PartPlan?: number;

    /**
     * 12月兼职实际
     */
    m12PartActual?: string;
    /**
     * 合计行
     */
    summary?: string;
    /**
     * 备注
     */
    remark?: string;
  }
}

/**
 * 查询编制规划记录明细列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/employee/staffingPlanData/page', { params });
}
/**
 * 查询编制规划记录明细详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/employee/staffingPlanData/${id}`);
}
/**
 * 新增编制规划记录明细
 * @param data
 */
export function apiAdd(data: StaffingPlanDataApi.StaffingPlanData) {
  return requestClient.post('/employee/staffingPlanData', data);
}
/**
 * 修改编制规划记录明细
 * @param data
 */
export function apiUpdate(data: StaffingPlanDataApi.StaffingPlanData[]) {
  return requestClient.put('/employee/staffingPlanData', data);
}
/**
 * 删除编制规划记录明细
 * @param id
 */
export function apiDelete(id: Array<number> | number) {
  return requestClient.delete(`/employee/staffingPlanData/${id}`);
}
/**
 * 导出编制规划记录明细
 * @param params
 */
export function apiExport(id: number) {
  return commonExport(`/employee/staffingPlanData/export/${id}`, {});
}

/**
 * 下载用户导入模板
 * @returns blob
 */
export function downloadImportTemplate() {
  return commonExport('/employee/staffingPlanData/importTemplate', {});
}

/**
 * 从excel导入培训信息
 * @param file
 * @returns void
 */
export function staffingPlanDataImportData(recordId: number, file: Blob) {
  return requestClient.post<{ errMessage: string; success: boolean }>(
    `/employee/staffingPlanData/import/${recordId}`,
    { file },
    {
      headers: {
        'Content-Type': 'multipart/form-data;charset=UTF-8',
      },
      isTransformResponse: false,
      responseReturn: 'body',
      timeout: 300_000,
    },
  );
}
