import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace EmployeeStatusAnalysisApi {
  export interface EmployeeStatusAnalysis extends BaseModel {
    /**
     * 总人数
     */
    totalCount?: number;

    /**
     * 男性人数
     */
    maleCount?: number;

    /**
     * 女性人数
     */
    femaleCount?: number;

    /**
     * 24岁以下人数
     */
    under24Count?: number;

    /**
     * 25-34岁人数
     */
    age25To34Count?: number;

    /**
     * 35-44岁人数
     */
    age35To44Count?: number;

    /**
     * 45岁以上人数
     */
    over45Count?: number;

    /**
     * 专科以下人数
     */
    belowCollegeCount?: number;

    /**
     * 专科人数
     */
    collegeCount?: number;

    /**
     * 本科人数
     */
    bachelorCount?: number;

    /**
     * 硕士人数
     */
    masterCount?: number;

    /**
     * 小于2年人数
     */
    lessThan2YearsCount?: number;

    /**
     * 2年到5年人数
     */
    years2To5Count?: number;

    /**
     * 5年到10年人数
     */
    years5To10Count?: number;

    /**
     * 10年以上人数
     */
    over10YearsCount?: number;

    /**
     * 男性占比
     */
    maleRatio?: number;

    /**
     * 女性占比
     */
    femaleRatio?: number;

    /**
     * 24岁以下占比
     */
    under24Ratio?: number;

    /**
     * 25-34岁占比
     */
    age25To34Ratio?: number;

    /**
     * 35-44岁占比
     */
    age35To44Ratio?: number;

    /**
     * 45岁以上占比
     */
    over45Ratio?: number;

    /**
     * 专科以下占比
     */
    belowCollegeRatio?: number;

    /**
     * 专科占比
     */
    collegeRatio?: number;

    /**
     * 本科占比
     */
    bachelorRatio?: number;

    /**
     * 硕士占比
     */
    masterRatio?: number;

    /**
     * 小于2年占比
     */
    lessThan2YearsRatio?: number;

    /**
     * 2年到5年占比
     */
    years2To5Ratio?: number;

    /**
     * 5年到10年占比
     */
    years5To10Ratio?: number;

    /**
     * 10年以上占比
     */
    over10YearsRatio?: number;
  }
}

/**
 * 查询在职人员情况分析列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/employee/statusAnalysis/page', { params });
}
// /**
//  * 查询在职人员情况分析详细
//  * @param id
//  */
// export function apiDetail(id: number) {
//   return requestClient.get(`/employee/employeeStatusAnalysis/${id}`);
// }
// /**
//  * 新增在职人员情况分析
//  * @param data
//  */
// export function apiAdd(data: EmployeeStatusAnalysisApi.EmployeeStatusAnalysis) {
//   return requestClient.post('/employee/employeeStatusAnalysis', data);
// }
// /**
//  * 修改在职人员情况分析
//  * @param data
//  */
// export function apiUpdate(data: EmployeeStatusAnalysisApi.EmployeeStatusAnalysis) {
//   return requestClient.put('/employee/employeeStatusAnalysis', data);
// }
// /**
//  * 删除在职人员情况分析
//  * @param id
//  */
// export function apiDelete(id: Array<number> | number) {
//   return requestClient.delete(`/employee/employeeStatusAnalysis/${id}`);
// }
/**
 * 导出在职人员情况分析
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/employee/statusAnalysis/export', params);
}
