import type { BaseModel } from '#/api/baseModel';

export namespace EmployeeInfoApi {
  export interface Employee extends BaseModel {
    /**
     * 板块
     */
    plate?: string;
    /**
     * 一级部门
     */
    firstLevelDepartment?: string;
    /**
     * 二级部门
     */
    secondLevelDepartment?: string;
    /**
     * 三级部门
     */
    thirdLevelDepartment?: string;
    /**
     * 部门ID
     */
    deptId?: number;

    /**
     * 工号
     */
    employeeNo?: number;

    /**
     * 职级
     */
    jobLevel?: number;

    /**
     * 岗位类型
     */
    positionType?: string;
    positionTypeName?: string;
    /**
     * 序列
     */
    sequence?: string;
    sequenceName?: string;
    /**
     * 主岗位
     */
    position?: string;
    /**
     * 姓名
     */
    name?: string;
    /**
     * 性别
     */
    gender?: string;
    genderName?: string;
    /**
     * 身份证号码
     */
    idCardNumber?: number;

    /**
     * 照片
     */
    photo?: string;
    /**
     * 图片ID
     */
    ossId?: number;
    /**
     * 出生日期
     */
    birthDate?: string;
    /**
     * 年龄
     */
    age?: number;

    /**
     * 年龄段
     */
    ageGroup?: string;
    ageGroupName?: string;
    /**
     * 兼岗板块
     */
    concurrentPlate?: string;
    /**
     * 兼岗一级部门
     */
    concurrentFirstDept?: string;
    /**
     * 兼岗二级部门
     */
    concurrentSecondDept?: string;
    /**
     * 兼岗三级部门
     */
    concurrentThirdDept?: string;
    /**
     * 兼岗岗位
     */
    concurrentPosition?: string;

    /**
     * 兼岗岗位类型
     */
    concurrentPositionType?: string;
    concurrentPositionTypeName?: string;
    /**
     * 籍贯
     */
    nativePlace?: string;
    /**
     * 民族
     */
    ethnicity?: string;
    /**
     * 婚姻状况
     */
    maritalStatus?: string;
    maritalStatusName?: string;
    /**
     * 政治面貌
     */
    politicalStatus?: string;
    politicalStatusName?: string;
    /**
     * 手机号码
     */
    phoneNumber?: string;
    /**
     * 紧急联系人
     */
    emergencyContact?: string;
    /**
     * 紧急联系人电话
     */
    emergencyContactPhone?: string;
    /**
     * 家庭地址
     */
    homeAddress?: string;
    /**
     * 户口所在地
     */
    householdRegistrationAddress?: string;
    /**
     * 参加工作时间
     */
    workStartDate?: string;
    /**
     * 入职时间
     */
    entryDate?: string;
    /**
     * 工龄
     */
    yearsOfService?: string;
    /**
     * 工龄段
     */
    yearsOfServiceSegment?: string;
    yearsOfServiceSegmentName?: string;
    /**
     * 全日制学历
     */
    fulltimeEducation?: string;
    /**
     * 全日制毕业院校
     */
    fulltimeSchool?: string;
    /**
     * 全日制专业
     */
    fulltimeMajor?: string;
    /**
     * 全日制毕业日期
     */
    fulltimeGraduationDate?: string;
    /**
     * 全日制学位
     */
    fulltimeDegree?: string;
    /**
     * 非全日制学历
     */
    nonFulltimeEducation?: string;
    /**
     * 非全日制毕业院校
     */
    nonFulltimeSchool?: string;
    /**
     * 非全日制专业
     */
    nonFulltimeMajor?: string;
    /**
     * 非全日制毕业日期
     */
    nonFulltimeGraduationDate?: string;
    /**
     * 非全日制学位
     */
    nonFulltimeDegree?: string;
    /**
     * 学历分类
     */
    educationCategory?: string;
    educationCategoryName?: string;
    /**
     * 员工类型
     */
    employeeType?: string;
    employeeTypeName?: string;
    /**
     * 职称情况
     */
    professionalTitle?: string;
    /**
     * 证书情况
     */
    certificateStatus?: string;
    /**
     * 外部个人履历
     */
    externalResume?: string;
    /**
     * 内部个人履历
     */
    internalResume?: string;
    /**
     * 用工形式
     */
    employmentForm?: string;
    employmentFormName?: string;
    /**
     * 合同形式
     */
    contractForm?: string;
    contractFormName?: string;
    /**
     * 劳动合同期限
     */
    contractTerm?: string;
    /**
     * 劳动合同开始时间
     */
    contractStartDate?: string;
    /**
     * 劳动合同截止时间
     */
    contractEndDate?: string;
    /**
     * 合同到期提醒
     */
    contractExpirationReminder?: string;
    /**
     * 劳动合同签订情况
     */
    contractSigningStatus?: string;
    /**
     * 合同主体
     */
    contractEntity?: string;
    /**
     * 社保主体
     */
    socialSecurityEntity?: string;
    /**
     * 是否缴纳社保
     */
    hasSocialSecurityPaid?: string;
    hasSocialSecurityPaidName?: string;

    /**
     * 公积金主体
     */
    providentFundEntity?: string;

    /**
     * 是否缴纳公积金
     */
    hasProvidentFundPaid?: string;
    hasProvidentFundPaidName?: string;

    /**
     * 是否缴纳雇主险
     */
    hasEmployerInsurancePaid?: string;
    hasEmployerInsurancePaidName?: string;

    /**
     * 试用期（月数）
     */
    probationPeriod?: number;

    /**
     * 转正时间
     */
    regularizationDate?: string;
    /**
     * 奖励情况
     */
    rewardStatus?: string;
    /**
     * 处罚情况
     */
    punishmentStatus?: string;
    /**
     * 备注
     */
    remarks?: string;
    /**
     * 办公电话
     */
    officePhone?: string;
    /**
     * 短线
     */
    shortLine?: string;
    /**
     * 银行卡号
     */
    bankCardNumber?: string;
    /**
     * 开户行
     */
    bankName?: string;
    /**
     * 公司内是否有亲属关系
     */
    hasRelativeInCompany?: string;
    hasRelativeInCompanyName?: string;
    /**
     * 亲属姓名
     */
    relativeName?: string;
    /**
     * 介绍人
     */
    introducer?: string;

    /**
     * 介绍人关系
     */
    introducerRelation?: string;
    /**
     * 工资发放地
     */
    salaryLocation?: string;

    /**
     * 编制所在地
     */
    staffingLocation?: string;

    /**
     * 成本费用所属(写部门)
     */
    costOfDept?: string;

    /**
     * 成本费用细分
     */
    costType?: string;
    costTypeName?: string;
    /**
     * 绩效比例
     */
    performanceRatio?: string;

    /**
     * 工装(某年某月发放价值多少钱的工装)
     */
    workwearDetail?: string;

    /**
     * 内部购房优惠(是，否)
     */
    internalPurchaseDiscounts?: string;
    internalPurchaseDiscountsName?: string;

    /**
     * 安泰业主(是，否)
     */
    antaiHomeowners?: string;
    antaiHomeownersName?: string;

    /**
     * 安泰小区信息
     */
    antaiCommunityInfo?: string;

    /**
     * 员工家庭成员
     */
    familyMembers?: EmployeeFamilyMembersVo[];

    /**
     * 离职类型
     */
    resignationType?: string;
    resignationTypeName?: string;

    /**
     * 离职类别
     */
    resignationCategory?: string;
    resignationCategoryName?: string;
    /**
     * 离职时间
     */
    resignationDate?: string;
    /**
     * 离职原因
     */
    resignationReason?: string;
    /**
     * 最后结薪日
     */
    finalPayDate?: string;
    /**
     * 离职申请状态
     */
    resignationApplyStatus?: number;
    resignationApplyStatusName?: string;

    /**
     * 入职审批状态
     */
    entryApplyStatus?: number;
    entryApplyStatusName?: string;

    /**
     * 调配申请状态
     */
    transferApplyStatus?: number;
    transferApplyStatusName?: string;

    /**
     * 状态
     */
    status?: number;
    statusName?: string;

    /**
     * 签订兼职协议
     */
    partTimeAgreement?: string;
    partTimeAgreementName?: string;
    /**
     * 协议主体
     */
    agreementEntity?: string;
    /**
     * 协议期限
     */
    agreementPeriod?: string;
    /**
     * 协议开始时间
     */
    agreementStartDate?: string;
    /**
     * 协议截止时间
     */
    agreementEndDate?: string;
  }

  export interface EmployeeApplyBaseBo {
    /**
     * 序号
     */
    id?: number;

    /**
     * 申请编号
     */
    applyCode?: string;

    /**
     * 流程code
     */
    flowCode?: string;

    /**
     * 员工id
     */
    employeeId?: number;

    /**
     * 部门名称
     */
    deptName?: string;

    /**
     * 员工姓名
     */
    name?: string;

    /**
     * 备注
     */
    remark?: string;

    /**
     * 审核列表
     */
    auditLogList?: AuditLogBo[];
  }

  export interface EmployeeApplyBo extends EmployeeApplyBaseBo {
    /**
     * 入职时间
     */
    entryDate?: Date;
  }

  export interface EmployeeTransferApplyBo extends EmployeeApplyBaseBo {
    /**
     * 板块
     */
    plate?: string;
    /**
     * 一级部门
     */
    firstLevelDepartment?: string;
    /**
     * 二级部门
     */
    secondLevelDepartment?: string;
    /**
     * 三级部门
     */
    thirdLevelDepartment?: string;
    /**
     * 部门ID
     */
    deptId?: number;
    /**
     * 原先部门
     */
    oldDeptName?: string;
    /**
     * 主岗位
     */
    position?: string;
    /**
     * 调配时间
     */
    transferDate?: Date;
    /**
     * 编制所在地
     */
    staffingLocation?: string;

    /**
     * 成本费用所属(写部门)
     */
    costOfDept?: string;

    /**
     * 成本费用细分
     */
    costType?: string;
    /**
     * 绩效比例
     */
    performanceRatio?: string;
    /**
     * 内部个人履历
     */
    internalResume?: string;
  }

  export interface EmployeeResignApplyBo extends EmployeeApplyBaseBo {
    /**
     * 离职类型
     */
    resignationType?: string;
    /**
     * 离职时间
     */
    resignationDate?: Date;
    /**
     * 离职类别
     */
    resignationCategory?: string;
    /**
     * 离职原因
     */
    resignationReason?: string;
    /**
     * 最后结薪日
     */
    finalPayDate?: Date;
  }
  export interface EmployeeRegularApplyBo extends EmployeeApplyBaseBo {
    /**
     * 劳动合同开始时间
     */
    contractStartDate?: Date;
    /**
     * 劳动合同截止时间
     */
    contractEndDate?: Date;
    /**
     * 劳动合同签订情况
     */
    contractSigningStatus?: string;
    /**
     * 合同主体
     */
    contractEntity?: string;
    /**
     * 社保主体
     */
    socialSecurityEntity?: string;
    /**
     * 是否缴纳社保
     */
    hasSocialSecurityPaid?: string;
    /**
     * 公积金主体
     */
    providentFundEntity?: string;
    /**
     * 是否缴纳公积金
     */
    hasProvidentFundPaid?: string;
    /**
     * 是否缴纳雇主险
     */
    hasEmployerInsurancePaid?: string;
    /**
     * 转正时间
     */
    regularizationDate?: Date;
  }
  export interface EmployeeRenewalContractApplyBo extends EmployeeApplyBaseBo {
    /**
     * 劳动合同开始时间
     */
    contractStartDate?: Date;
    /**
     * 劳动合同截止时间
     */
    contractEndDate?: Date;
    /**
     * 合同形式
     */
    contractForm?: string;
    /**
     * 劳动合同签订情况
     */
    contractSigningStatus?: string;
  }
}

/**
 * 审核记录
 */
export interface AuditLogBo {
  /**
   * 字段名称
   */
  auditField: string;

  /**
   * 字段注释名称
   */
  auditFieldName: string;

  /**
   * 变更后值
   */
  afterVal: string;
}

export interface EmployeeFamilyMembersVo {
  /**
   * 序号
   */
  id?: number;
  /**
   * 员工信息ID
   */
  employeeId?: number;
  /**
   * 关系
   */
  relation?: string;
  /**
   * 姓名
   */
  name?: string;
  /**
   * 出生年月
   */
  birthDate?: string;
  /**
   * 工作单位及职务
   */
  companyAndJob?: string;
  /**
   * 联系方式
   */
  contact?: string;
  /**
   * 是否为紧急联系人
   */
  emergencyFlag?: string;
  emergencyFlagName?: string;
}
