import { requestClient } from '#/api/request';

export interface User {
  id: number;
  name: string;
  username: string;
  deptId: number;
  deptName: string;
  phone: string;
  email: string;
  isAdmin: string;
  isEnable: string;
  tenantId: string;
  remark: string;
}

export interface UserInfoResp {
  authorities: string[];
  roles: string[];
  sysUser: User;
  homePath: string;
}

/**
 * 获取用户信息
 */
export async function getUserInfoApi() {
  return requestClient.get<UserInfoResp>('/user/info');
}
