import type { BaseModel, PageQuery } from '#/api/baseModel';

import { requestClient } from '#/api/request';

export namespace SysClientApi {
  export interface Client extends BaseModel {
    /**
     * 客户端id
     */
    clientId?: number | string;

    /**
     * 客户端key
     */
    clientKey?: string;
    /**
     * 客户端秘钥
     */
    clientSecret?: string;
    /**
     * 授权类型
     */
    grantTypeList?: string[];
    /**
     * 设备类型
     */
    deviceType?: string;
    /**
     * token活跃超时时间
     */
    activeTimeout?: number;

    /**
     * token固定超时时间
     */
    timeout?: number;

    /**
     * 状态（0正常 1停用）
     */
    status?: number;
  }
}

/**
 * 查询终端信息列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/system/client/list', { params });
}
/**
 * 查询终端信息详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/system/client/detail/${id}`);
}
// /**
//  * 新增终端信息
//  * @param data
//  */
// export function apiSave(data: SysClientApi.Client) {
//   return requestClient.post('/system/client', data);
// }
/**
 * 新增终端信息
 * @param data
 */
export function apiAdd(data: SysClientApi.Client) {
  return requestClient.post('/system/client', data);
}
/**
 * 修改终端信息
 * @param data
 */
export function apiUpdate(data: SysClientApi.Client) {
  return requestClient.put('/system/client', data);
}
/**
 * 删除终端信息
 * @param id
 */
export function apiDelete(id: Array<number> | number) {
  return requestClient.delete(`/system/client/${id}`);
}
/**
 * 导出终端信息
 * @param params
 */
export function apiExport(params: PageQuery) {
  return requestClient.post('/system/client/export', params);
}
/**
 * 修改终端状态
 * @param data
 */
export function changeStatus(data: SysClientApi.Client) {
  return requestClient.post('/system/client/changeStatus', data);
}
