import type { VbenFormSchema } from '#/adapter/form';
import type { OnActionClickFn, VxeTableGridOptions } from '#/adapter/vxe-table';
import type { TrainingApi } from '#/api/hr/training';

export const querySchema: VbenFormSchema[] = [
  // {
  //   component: 'Input',
  //   fieldName: 'employeeId',
  //   label: '员工信息ID',
  // },
  {
    component: 'Input',
    fieldName: 'name',
    label: '姓名',
  },
  {
    component: 'Input',
    fieldName: 'trainingCourse',
    label: '培训课程',
  },
  {
    component: 'Input',
    fieldName: 'trainingInstitution',
    label: '培训机构',
  },
  {
    component: 'Input',
    fieldName: 'trainer',
    label: '培训讲师',
  },
  {
    component: 'DatePicker',
    fieldName: 'trainingTime',
    label: '参训时间',
  },
  {
    component: 'DatePicker',
    fieldName: 'serviceEndDate',
    label: '服务期',
  },
  {
    component: 'Input',
    fieldName: 'serviceYears',
    label: '服务年限',
  },
  {
    component: 'Input',
    fieldName: 'trainingAmount',
    label: '培训金额',
  },
];

export function useColumns(
  onActionClick: OnActionClickFn<TrainingApi.Training>,
): VxeTableGridOptions<TrainingApi.Training>['columns'] {
  return [
    // {
    //   title: '员工信息ID',
    //   field: 'employeeId',
    // },
    {
      title: '姓名',
      field: 'name',
    },
    {
      title: '身份证号',
      field: 'idCardNumber',
    },
    {
      title: '培训课程',
      field: 'trainingCourse',
    },
    {
      title: '培训机构',
      field: 'trainingInstitution',
    },
    {
      title: '培训讲师',
      field: 'trainer',
    },
    {
      title: '参训时间',
      field: 'trainingTime',
      formatter: 'formatDate',
    },
    {
      title: '服务期',
      field: 'serviceEndDate',
      formatter: 'formatDate',
    },
    {
      title: '服务年限',
      field: 'serviceYears',
    },
    {
      title: '培训金额',
      field: 'trainingAmount',
    },
    {
      title: '备注',
      field: 'remark',
    },
    {
      align: 'right',
      cellRender: {
        attrs: {
          nameField: 'name',
          nameTitle: '员工培训档案',
          onClick: onActionClick,
        },
        name: 'CellOperation',
        options: [
          {
            code: 'edit',
            accessCode: ['employee:training:edit'],
          }, // 默认的编辑按钮
          {
            code: 'delete',
            accessCode: ['employee:training:remove'],
          }, // 默认的删除按钮
        ],
      },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
