import type { VbenFormSchema } from '#/adapter/form';
import type { VxeTableGridOptions } from '#/adapter/vxe-table';
import type { EmployeeFlowApi } from '#/api/hr/employeeFlow';

import { DictEnum } from '@vben/constants';

import { getTagDicts } from '#/utils/dict';

export const flowTypeOptions = [
  { label: '入职', value: '1' },
  { label: '离职', value: '2' },
  { label: '调配', value: '3' },
  { label: '转正', value: '4' },
  { label: '续签', value: '5' },
  { label: '部门调整', value: '6' },
];

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'applyCode',
    label: '申请编号',
  },
  {
    component: 'Select',
    componentProps: {
      options: flowTypeOptions,
    },
    fieldName: 'flowType',
    label: '审批类型',
  },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'startDate',
  //   label: '开始时间',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'endDate',
  //   label: '结束时间',
  // },
];

export function useColumns(): VxeTableGridOptions<EmployeeFlowApi.EmployeeFlow>['columns'] {
  // onActionClick: OnActionClickFn<EmployeeFlowApi.EmployeeFlow>,
  return [
    {
      title: '申请编号',
      field: 'applyCode',
    },
    {
      title: '审批类型',
      field: 'flowType',
      cellRender: { name: 'CellTag', options: flowTypeOptions },
    },
    // {
    //   title: '员工信息ID',
    //   field: 'employeeId',
    // },
    // {
    //   title: '开始时间',
    //   field: 'startDate',
    //   formatter: 'formatDateTime',
    // },
    // {
    //   title: '结束时间',
    //   field: 'endDate',
    //   formatter: 'formatDateTime',
    // },
    {
      title: '状态',
      field: 'status',
      cellRender: {
        name: 'CellTag',
        options: [getTagDicts(DictEnum.WF_BUSINESS_STATUS)],
      },
    },
    {
      title: '备注',
      field: 'remark',
    },
    {
      align: 'right',
      slots: { default: 'action' },
      // cellRender: {
      //   attrs: {
      //     nameField: 'name',
      //     nameTitle: '人事审批对象',
      //     onClick: onActionClick,
      //   },
      //   name: 'CellOperation',
      //   options: [
      //     {
      //       code: 'edit',
      //       accessCode: ['employee:flow:edit'],
      //     }, // 默认的编辑按钮
      //     {
      //       code: 'delete',
      //       accessCode: ['employee:flow:remove'],
      //     }, // 默认的删除按钮
      //   ],
      // },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
