import type { RouteRecordRaw } from 'vue-router';

const routes: RouteRecordRaw[] = [
  // 人事管理
  {
    path: '/hr',
    name: 'HrManagement',
    meta: {
      title: '人事管理',
      keepAlive: true,
      icon: 'streamline-ultimate:human-resources-hierarchy-1',
      permission: ['dashboard'],
    },
    children: [
      {
        path: '/hr/employee/list',
        name: 'EmployeeInfoList',
        component: () => import('#/views/hr/employeeInfo/list.vue'),
        meta: {
          title: '员工信息列表',
          icon: 'clarity:employee-line',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/employeeInfo/list.vue',
        },
      },
      {
        path: '/hr/resignEmployee/list',
        name: 'ResignEmployeeList',
        component: () => import('#/views/hr/employeeInfo/list.vue'),
        meta: {
          title: '离职员工列表',
          icon: 'clarity:employee-line',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/resignEmployee/list.vue',
        },
      },
      {
        path: '/hr/phoneBook/list',
        name: 'PhoneBookList',
        component: () => import('#/views/hr/phoneBook/list.vue'),
        meta: {
          title: '电话本管理',
          icon: 'solar:monitor-smartphone-outline',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/phoneBook/list.vue',
        },
      },
      {
        path: '/hr/regularReminder/list',
        name: 'RegularReminderList',
        component: () => import('#/views/hr/regularReminder/list.vue'),
        meta: {
          title: '转正提醒管理',
          icon: 'solar:monitor-smartphone-outline',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/regularReminder/list.vue',
        },
      },
      {
        path: '/hr/contractExpiration/list',
        name: 'ContractExpirationReminder',
        component: () =>
          import('#/views/hr/contractExpirationReminder/list.vue'),
        meta: {
          title: '合同续约提醒',
          icon: 'solar:monitor-smartphone-outline',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/contractExpirationReminder/list.vue',
        },
      },
      {
        path: '/hr/changeLog/list',
        name: 'EmployeeChangeLogList',
        component: () => import('#/views/hr/changeLog/list.vue'),
        meta: {
          title: '员工变动记录',
          icon: 'solar:monitor-smartphone-outline',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/changeLog/list.vue',
        },
      },
      {
        path: '/hr/report',
        name: 'HrReport',
        meta: {
          title: '报表',
          keepAlive: true,
          icon: 'material-symbols:logo-dev-outline',
          permission: ['dashboard'],
        },
        children: [
          {
            path: '/hr/report/changeAnalysis',
            name: 'EmployeeChangeAnalysisList',
            component: () => import('#/views/hr/changeAnalysis/list.vue'),
            meta: {
              title: '人员变化分析',
              icon: 'arcticons:one-hand-operation',
              keepAlive: true,
              permission: ['dashboard'],
              componentPath: '#/views/hr/changeAnalysis/list.vue',
            },
          },
        ],
      },
      {
        name: 'EmployeeFlowList',
        path: '/hr/employee/flow',
        // hidden: false,
        component: () => import('#/views/workflow/hrFlow/list.vue'),
        meta: {
          title: '人事申请',
          icon: 'fluent-mdl2:leave-user',
          noCache: false,
          componentPath: '#/views/workflow/hrFlow/list.vue',
          // link: null,
        },
      },
    ],
  },
];

export default routes;
