import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace EmployeeDeptApi {
  export interface EmployeeDept extends BaseModel {
    /**
     * 父级部门
     */
    parentId?: number;

    /**
     * 部门名称
     */
    name?: string;
    /**
     * 祖级关系
     */
    nodePath?: string;
    /**
     * 显示顺序
     */
    orderNum?: number;

    /**
     * 状态
     */
    status?: number;
  }
}

/**
 * 查询员工部门列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/employee/dept/page', { params });
}
/**
 * 查询员工部门详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/employee/dept/${id}`);
}
/**
 * 新增员工部门
 * @param data
 */
export function apiAdd(data: EmployeeDeptApi.EmployeeDept) {
  return requestClient.post('/employee/dept', data);
}
/**
 * 修改员工部门
 * @param data
 */
export function apiUpdate(data: EmployeeDeptApi.EmployeeDept) {
  return requestClient.put('/employee/dept', data);
}
/**
 * 删除员工部门
 * @param id
 */
export function apiDelete(id: Array<number> | number) {
  return requestClient.delete(`/employee/dept/${id}`);
}
/**
 * 导出员工部门
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/employee/dept/export', params);
}

/**
 * 根据部门等级查询部门名称
 * @param level
 */
export function selectDeptNamesByLevel(level: number) {
  return requestClient.get(`/employee/dept/deptNames/${level}`);
}

/**
 * 根据父级部门名称查询部门名称
 * @param name
 */
export function selectDeptNamesByParent(name: string) {
  return requestClient.get(`/employee/dept/deptNamesByParentName/${name}`);
}
