import type { VbenFormSchema } from '#/adapter/form';
import type { VxeTableGridOptions } from '#/adapter/vxe-table';
import type { ChangeAnalysisApi } from '#/api/hr/changeAnalysis';

import dayjs from 'dayjs';

export const querySchema: VbenFormSchema[] = [
  // {
  //   component: 'Input',
  //   fieldName: 'plate',
  //   label: '板块',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'plateId',
  //   label: '板块ID',
  // },
  {
    component: 'RangePicker',
    fieldName: 'entryDate',
    defaultValue: [dayjs().subtract(1, 'months'), dayjs()],
    label: '统计时间',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'beginningCount',
  //   label: '期初人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'entryCount',
  //   label: '入职人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'regularCount',
  //   label: '转正人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'transferIn',
  //   label: '转入',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'transferOut',
  //   label: '转出',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'probationPeriod',
  //   label: '试用期内',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'within3Years',
  //   label: '入职3年内',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'over3Years',
  //   label: '入职3年以上',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'passiveResignation',
  //   label: '被动离职',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'totalResignation',
  //   label: '总离职',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'endingCount',
  //   label: '期末人数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'probationResignationRate',
  //   label: '试用期内离职率',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'within3YearsResignationRate',
  //   label: '入职3年内离职率',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'over3YearsResignationRate',
  //   label: '入职3年以上离职率',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'passiveResignationRate',
  //   label: '被动离职率',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'totalResignationRate',
  //   label: '总离职率',
  // },
];

export function useColumns(): VxeTableGridOptions<ChangeAnalysisApi.ChangeAnalysis>['columns'] {
  return [
    {
      title: '公司',
      field: 'plate',
    },
    // {
    //   title: '板块ID',
    //   field: 'plateId',
    // },
    {
      title: '期初人数',
      field: 'beginningCount',
    },
    {
      title: '入职人数',
      field: 'entryCount',
    },
    {
      title: '转正人数',
      field: 'regularCount',
    },
    {
      title: '异动人数',
      headerAlign: 'center',
      children: [
        {
          title: '调入',
          field: 'transferIn',
        },
        {
          title: '调出',
          field: 'transferOut',
        },
      ],
    },
    {
      title: '月离职人数',
      headerAlign: 'center',
      children: [
        {
          title: '主动离职',
          headerAlign: 'center',
          children: [
            {
              title: '试用期内（6个月）',
              field: 'probationPeriod',
            },
            {
              title: '入职3年内',
              field: 'within3Years',
            },
            {
              title: '入职3年以上',
              field: 'over3Years',
            },
          ],
        },
        {
          title: '被动离职',
          field: 'passiveResignation',
        },
        {
          title: '总离职',
          field: 'totalResignation',
        },
      ],
    },

    {
      title: '期末人数',
      field: 'endingCount',
    },
    {
      title: '月离职率',
      headerAlign: 'center',
      children: [
        {
          title: '主动离职率',
          headerAlign: 'center',
          children: [
            {
              title: '试用期内离职率',
              field: 'probationResignationRate',
            },
            {
              title: '入职3年内离职率',
              field: 'within3YearsResignationRate',
            },
            {
              title: '入职3年以上离职率',
              field: 'over3YearsResignationRate',
            },
          ],
        },
        {
          title: '被动离职率',
          field: 'passiveResignationRate',
        },
        {
          title: '总离职率',
          field: 'totalResignationRate',
        },
      ],
    },
    // {
    //   align: 'right',
    //   slots: { default: 'action' },
    // cellRender: {
    //   attrs: {
    //     nameField: 'name',
    //     nameTitle: '人员变化分析',
    //     onClick: onActionClick,
    //   },
    //   name: 'CellOperation',
    //   options: [
    //     {
    //       code: 'edit',
    //       accessCode: ['hr:changeAnalysis:edit'],
    //     }, // 默认的编辑按钮
    //     {
    //       code: 'delete',
    //       accessCode: ['hr:changeAnalysis:remove'],
    //     }, // 默认的删除按钮
    //   ],
    // },
    // field: 'action',
    //   fixed: 'right',
    //   headerAlign: 'center',
    //   resizable: false,
    //   showOverflow: false,
    //   title: '操作',
    //   width: 'auto',
    // },
  ];
}
