import type { VbenFormSchema } from '#/adapter/form';
import type { OnActionClickFn, VxeTableGridOptions } from '#/adapter/vxe-table';
import type { LaborCostApi } from '#/api/hr/laborCost';

export const querySchema: VbenFormSchema[] = [
  {
    component: 'DatePicker',
    fieldName: 'recordDate',
    label: '记录时间',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'ossId',
  //   label: '文件ID',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'fileKey',
  //   label: '文件Key',
  // },
];

export function useColumns(
  onActionClick: OnActionClickFn<LaborCostApi.LaborCost>,
): VxeTableGridOptions<LaborCostApi.LaborCost>['columns'] {
  return [
    {
      title: '记录时间',
      field: 'recordDate',
      formatter: 'formatDate',
    },
    // {
    //   title: '文件ID',
    //   field: 'ossId',
    // },
    // {
    //   title: '文件Key',
    //   field: 'fileKey',
    // },
    {
      title: '备注',
      field: 'remark',
    },
    {
      align: 'right',
      cellRender: {
        attrs: {
          nameField: 'recordDate',
          nameTitle: '人工成本档案',
          onClick: onActionClick,
        },
        name: 'CellOperation',
        options: [
          {
            code: 'edit',
            accessCode: ['employee:laborCost:edit'],
            name: '查看',
          }, // 默认的编辑按钮
          {
            code: 'delete',
            accessCode: ['employee:laborCost:remove'],
          }, // 默认的删除按钮
        ],
      },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
