import type { VbenFormSchema } from '#/adapter/form';
import type { VxeTableGridOptions } from '#/adapter/vxe-table';
import type { SysTenantApi } from '#/api/system/sysTenant';

import { useAccess } from '@vben/access';

import { apiChangeStatus } from '#/api/system/sysTenant';

/**
 * 与后台逻辑相同
 * 只有超级管理员能访问租户相关
 */
const { hasAccessByCodes } = useAccess();

// const isSuperAdmin = computed(() => {
//   return hasAccessByRoles(['superadmin']);
// });

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'tenantCode',
    label: '租户编号',
  },
  {
    component: 'Input',
    fieldName: 'companyName',
    label: '租户名称',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'contactUserName',
  //   label: '联系人',
  // },
  {
    component: 'Input',
    fieldName: 'contactPhone',
    label: '联系电话',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'licenseNumber',
  //   label: '统一社会信用代码',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'address',
  //   label: '地址',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'domain',
  //   label: '域名',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'intro',
  //   label: '企业简介',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'packageId',
  //   label: '租户套餐ID',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'expireTime',
  //   label: '过期时间',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'accountCount',
  //   label: '用户数量',
  // },
  // {
  //   component: 'Select',
  //   componentProps: {
  //     options: getDictOptions('sys_common_status'),
  //   },
  //   fieldName: 'status',
  //   label: '租户状态',
  // },
];

export function useColumns(): VxeTableGridOptions<SysTenantApi.Tenant>['columns'] {
  return [
    {
      title: '租户编号',
      field: 'tenantCode',
    },
    {
      title: '租户名称',
      field: 'companyName',
    },
    {
      title: '联系人',
      field: 'contactUserName',
    },
    {
      title: '联系电话',
      field: 'contactPhone',
    },
    // {
    //   title: '统一社会信用代码',
    //   field: 'licenseNumber',
    // },
    // {
    //   title: '地址',
    //   field: 'address',
    // },
    // {
    //   title: '域名',
    //   field: 'domain',
    // },
    // {
    //   title: '企业简介',
    //   field: 'intro',
    // },
    // {
    //   title: '租户套餐ID',
    //   field: 'packageId',
    // },
    {
      title: '过期时间',
      field: 'expireTime',
      formatter: ({ cellValue }) => {
        if (!cellValue) {
          return '无期限';
        }
        return cellValue;
      },
    },
    // {
    //   title: '用户数量',
    //   field: 'accountCount',
    // },
    {
      title: '租户状态',
      field: 'status',
      cellRender: {
        name: 'CellSwitch',
        props: {
          api: apiChangeStatus,
          confirm: true,
          disabled: (row: SysTenantApi.Tenant) => {
            return row.id === 1 || !hasAccessByCodes(['system:tenant:edit']);
          },
        },
      },
    },
    {
      align: 'right',
      // cellRender: {
      //   attrs: {
      //     nameField: 'companyName',
      //     nameTitle: '租户',
      //     onClick: onActionClick,
      //   },
      //   name: 'CellOperation',
      //   options: [
      //     {
      //       code: 'syncPackage',
      //       text: '同步套餐',
      //       accessCode: ['system:tenant:edit'],
      //       disabled: (row: SysTenantApi.Tenant) => {
      //         return !!(row.id === 1);
      //       },
      //       isConfirm: true,
      //     },
      //     {
      //       code: 'edit', // 默认的编辑按钮
      //       accessCode: ['system:tenant:edit'],
      //       disabled: (row: SysTenantApi.Tenant) => {
      //         return !!(row.id === 1);
      //       },
      //     },
      //     {
      //       code: 'delete', // 默认的删除按钮
      //       accessCode: ['system:tenant:remove'],
      //       disabled: (row: SysTenantApi.Tenant) => {
      //         return !!(row.id === 1);
      //       },
      //     },
      //   ],
      // },
      field: 'action',
      slots: { default: 'action' },
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
