import type { VbenFormSchema } from '#/adapter/form';
import type { VxeTableGridOptions } from '#/adapter/vxe-table';
import type { OssFile } from '#/api/system/oss';

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'fileName',
    label: '文件名',
  },
  {
    component: 'Input',
    fieldName: 'originalName',
    label: '原名',
  },
  {
    component: 'Input',
    fieldName: 'fileSuffix',
    label: '文件后缀名',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'url',
  //   label: 'URL地址',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'ext1',
  //   label: '扩展字段',
  // },
  {
    component: 'Input',
    fieldName: 'service',
    label: '服务商',
  },
  {
    component: 'RangePicker',
    fieldName: 'createTime',
    label: '创建时间',
  },
];

export function useColumns(): VxeTableGridOptions<OssFile>['columns'] {
  // onActionClick: OnActionClickFn<OssFile>,
  return [
    {
      title: '文件名',
      field: 'fileName',
    },
    {
      title: '原名',
      field: 'originalName',
    },
    {
      title: '文件后缀名',
      field: 'fileSuffix',
    },
    {
      title: '文件预览',
      field: 'url',
      showOverflow: true,
      slots: { default: 'url' },
    },
    {
      title: '创建时间',
      field: 'createTime',
      // sortable: true,
    },
    {
      title: '服务商',
      field: 'service',
    },
    {
      align: 'right',
      slots: { default: 'action' },
      // cellRender: {
      //   attrs: {
      //     nameField: 'name',
      //     nameTitle: 'OSS对象存储',
      //     onClick: onActionClick,
      //   },
      //   name: 'CellOperation',
      //   options: [
      //     {
      //       code: 'edit',
      //       accessCode: ['app:oss:edit'],
      //     }, // 默认的编辑按钮
      //     {
      //       code: 'delete',
      //       accessCode: ['app:oss:remove'],
      //     }, // 默认的删除按钮
      //   ],
      // },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
