import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace SysLogApi {
  export interface SysLog extends BaseModel {
    /**
     * 操作模块
     */
    title?: string;
    /**
     * 部门Id
     */
    deptId?: number;
    /**
     * 租户ID
     */
    tenantId?: number;
    /**
     * 操作人员
     */
    operName?: string;
    /**
     * 业务类型（0其它 1新增 2修改 3删除）
     */
    businessType?: string;
    /**
     * 操作类别（0其它 1后台用户 2手机端用户）
     */
    operatorType?: string;
    /**
     * 用户操作
     */
    operation?: string;
    /**
     * 操作方法
     */
    method?: string;
    /**
     * 请求方式
     */
    requestMethod?: string;
    /**
     * 请求url
     */
    url?: string;
    /**
     * 请求参数
     */
    params?: string;
    /**
     * 执行时长(毫秒)
     */
    costTime?: number;

    /**
     * IP地址
     */
    ip?: string;
    /**
     * 结果
     */
    result?: string;
    /**
     * 操作状态（0正常 1异常）
     */
    status?: number;

    /**
     * 错误消息
     */
    errorMsg?: string;
  }
}

/**
 * 查询SysLog列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/system/log/list', { params });
}
/**
 * 查询SysLog详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/system/log/${id}`);
}
/**
 * 新增SysLog
 * @param data
 */
export function apiAdd(data: SysLogApi.SysLog) {
  return requestClient.post('/system/log', data);
}
/**
 * 修改SysLog
 * @param data
 */
export function apiUpdate(data: SysLogApi.SysLog) {
  return requestClient.put('/system/log', data);
}
/**
 * 删除SysLog
 * @param id
 */
export function apiDelete(id: Array<number> | number) {
  return requestClient.delete(`/system/log/${id}`);
}
/**
 * 导出SysLog
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/system/log/export', params);
}
