import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace PhoneBookApi {
  export interface PhoneBook extends BaseModel {
    /**
     * 板块
     */
    plate?: string;
    /**
     * 一级部门
     */
    firstLevelDepartment?: string;
    /**
     * 二级部门
     */
    secondLevelDepartment?: string;
    /**
     * 三级部门
     */
    thirdLevelDepartment?: string;
    /**
     * 部门ID
     */
    deptId?: number;

    /**
     * 主岗位
     */
    position?: string;
    /**
     * 姓名
     */
    name?: string;
    /**
     * 手机号码
     */
    phoneNumber?: string;
    /**
     * 办公电话
     */
    officePhone?: string;
    /**
     * 短线
     */
    shortLine?: string;
    /**
     * 备注
     */
    remarks?: string;
  }
}

/**
 * 查询电话本管理列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/employee/phoneBook/page', { params });
}
// /**
//  * 查询电话本管理详细
//  * @param id
//  */
// export function apiDetail(id: number) {
//   return requestClient.get(`/hr/phoneBook/${id}`);
// }
// /**
//  * 新增电话本管理
//  * @param data
//  */
// export function apiAdd(data: PhoneBookApi.PhoneBook) {
//   return requestClient.post('/hr/phoneBook', data);
// }
// /**
//  * 修改电话本管理
//  * @param data
//  */
// export function apiUpdate(data: PhoneBookApi.PhoneBook) {
//   return requestClient.put('/hr/phoneBook', data);
// }
// /**
//  * 删除电话本管理
//  * @param id
//  */
// export function apiDelete(id: Array<number> | number) {
//   return requestClient.delete(`/hr/phoneBook/${id}`);
// }
/**
 * 导出电话本管理
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/employee/phoneBook/export', params);
}
