package com.anplus.hr.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.anplus.hr.constant.HrCacheConstants;
import com.anplus.hr.service.EmployeeSysDeptServ;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import top.binfast.app.biz.sysapi.bean.model.auth.SysDept;
import top.binfast.app.biz.sysapi.bean.vo.sysDept.SysDeptDTO;
import top.binfast.app.biz.sysapi.dao.auth.SysDeptMapper;
import top.binfast.app.biz.sysbiz.service.SysDeptServ;
import top.binfast.common.core.bean.dto.TreeDTO;
import top.binfast.common.core.util.LambdaUtil;
import top.binfast.common.core.util.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author 刘斌
 * @date 2025/11/6 11:30
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class EmployeeSysDeptServImpl implements EmployeeSysDeptServ {

    private final SysDeptMapper sysDeptMapper;
    private final SysDeptServ sysDeptServ;

    @Cacheable(cacheNames = HrCacheConstants.DEPT_AND_PARENT_NAME, key = "#deptId")
    @Override
    public List<String> selectDeptNameAncestorsById(Long deptId) {
        SysDeptDTO dept = sysDeptServ.selectDeptById(deptId);
        List<Long> split = StringUtils.splitTo(dept.getNodePath(), StrUtil.SLASH, Convert::toLong);
        if (split.size() <= 2) {
            return List.of(dept.getName());
        }
        List<SysDept> deptNameList = sysDeptMapper.selectByIds(split);
        return LambdaUtil.mapToList(deptNameList, SysDept::getName);
    }

    @Override
    public Map<String, Long> selectJoinDeptNames() {
//        if (CollUtil.isEmpty(joinNameSet)) {
//            return new HashMap<>();
//        }
        Map<String, Long> result = new HashMap<>();

        List<SysDeptDTO> sysDeptDTOS = sysDeptServ.deptTreeForOptions();
        traverseDeptTree(sysDeptDTOS, "",  result);
//        for (String joinName : joinNameSet) {
//            List<String> deptNameList = StrUtil.split(joinName, StrUtil.SLASH);
//
//        }
        return result;
    }

    // 遍历根节点列表
    private <T extends TreeDTO> void traverseDeptTree(List<T> deptList, String parentPath, Map<String, Long> result) {
        if (CollUtil.isEmpty(deptList)) {
            return;
        }

        for (TreeDTO dept : deptList) {
            String currentPath = StrUtil.isEmpty(parentPath) ? dept.getLabel() : parentPath + StrUtil.SLASH + dept.getLabel();

            // 递归处理子节点
            if (CollUtil.isNotEmpty(dept.getChildren())) {
                traverseDeptTree(dept.getChildren(), currentPath, result);
            } else {
                result.put(currentPath, dept.getId());
            }
        }
    }
}
