package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.constant.HrConstant;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.EmployeeInfoParam;
import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMappers;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Getter;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.bean.ExcelBaseEntity;
import top.binfast.common.excel.converters.ExcelDictConvert;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author 刘斌
 * @date 2025/10/29 09:42
 */
@Getter
@AutoMappers({
        @AutoMapper(target = EmployeeInfo.class, reverseConvertGenerate = false),
        @AutoMapper(target = EmployeeInfoParam.class, reverseConvertGenerate = false)
})
public class EmployeeInfoImportVo extends ExcelBaseEntity implements Serializable {
    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 板块
     */
    @NotBlank(message = "板块不能为空")
    @ExcelProperty(value = "板块")
    private String plate;

    /**
     * 项目
     */
    @NotBlank(message = "项目不能为空")
    @ExcelProperty(value = "项目")
    private String project;

    /**
     * 一级部门
     */
    @NotBlank(message = "一级部门不能为空")
    @ExcelProperty(value = "一级部门")
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @ExcelProperty(value = "二级部门")
    private String secondLevelDepartment;

    /**
     * 工号
     */
    @NotBlank(message = "工号不能为空")
    @ExcelProperty(value = "工号")
    private String employeeId;

    /**
     * 职级
     */
    @ExcelProperty(value = "职级")
    private String jobLevel;

    /**
     * 岗位
     */
    @NotBlank(message = "岗位不能为空")
    @ExcelProperty(value = "岗位")
    private String position;

    /**
     * 职务
     */
    @ExcelProperty(value = "职务")
    private String post;

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空")
    @ExcelProperty(value = "姓名")
    private String name;

    /**
     * 性别
     */
    @NotBlank(message = "性别不能为空")
    @ExcelProperty(value = "性别", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_USER_SEX)
    private String gender;

    /**
     * 简历图片
     */
    @ExcelProperty(value = "简历图片")
    private String resumeImage;

//    /**
//     * 性别
//     */
//    @UnTrans(type= UnTransType.DICTIONARY, dict= HrConstant.HR_USER_SEX,refs = {"genderName"})
//    private String gender;

    /**
     * 身份证号码
     */
    @NotBlank(message = "身份证号码不能为空")
    @ExcelProperty(value = "身份证号码")
    private String idCardNumber;

    /**
     * 出生日期
     */
    @ExcelProperty(value = "出生日期")
    private LocalDate birthDate;

    /**
     * 年龄
     */
    @NotNull(message = "年龄不能为空")
    @ExcelProperty(value = "年龄")
    private Integer age;

    /**
     * 年龄段
     */
    @ExcelProperty(value = "年龄段", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_AGE_GROUP)
    private String ageGroup;

//    /**
//     * 年龄段
//     */
////    @ExcelProperty(value = "年龄段")
//    @UnTrans(type= UnTransType.DICTIONARY, dict= HrConstant.HR_AGE_GROUP,refs = {"ageGroupName"})
//    private String ageGroup;

    /**
     * 籍贯
     */
    @ExcelProperty(value = "籍贯")
    private String nativePlace;

    /**
     * 民族
     */
    @ExcelProperty(value = "民族")
    private String ethnicity;

    /**
     * 婚姻状况
     */
    @ExcelProperty(value = "婚姻状况", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_MARITAL_STATUS)
    private String maritalStatus;

//    /**
//     * 婚姻状况
//     */
////    @ExcelProperty(value = "婚姻状况")
//    @UnTrans(type= UnTransType.DICTIONARY, dict= HrConstant.HR_MARITAL_STATUS,refs = {"maritalStatusName"})
//    private String maritalStatus;

    /**
     * 政治面貌
     */
    @ExcelProperty(value = "政治面貌", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_POLITICAL_STATUS)
    private String politicalStatus;
//
//    /**
//     * 政治面貌
//     */
//    @ExcelProperty(value = "政治面貌")
//    @UnTrans(type= UnTransType.DICTIONARY, dict= HrConstant.HR_POLITICAL_STATUS,refs = {"politicalStatusName"})
//    private String politicalStatus;

    /**
     * 手机号码
     */
    @NotBlank(message = "手机号码不能为空")
    @ExcelProperty(value = "手机号码")
    private String phoneNumber;

    /**
     * 紧急联系人
     */
    @ExcelProperty(value = "紧急联系人")
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
    @ExcelProperty(value = "紧急联系人电话")
    private String emergencyContactPhone;

    /**
     * 家庭地址
     */
    @ExcelProperty(value = "家庭地址")
    private String homeAddress;

    /**
     * 户口所在地
     */
    @ExcelProperty(value = "户口所在地")
    private String householdRegistrationAddress;

    /**
     * 参加工作时间
     */
    @ExcelProperty(value = "参加工作时间")
    private LocalDate workStartDate;

    /**
     * 入职时间
     */
    @ExcelProperty(value = "入职时间")
    private LocalDate entryDate;

    /**
     * 工龄
     */
    @ExcelProperty(value = "工龄")
    private String yearsOfService;

    /**
     * 工龄段
     */
    @ExcelProperty(value = "工龄段", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_YEARS_SERVICE_SEGMENT)
    private String yearsOfServiceSegment;

//    /**
//     * 工龄段
//     */
//    @ExcelProperty(value = "工龄段")
//    @UnTrans(type= UnTransType.DICTIONARY, dict= HrConstant.HR_YEARS_SERVICE_SEGMENT,refs = {"yearsOfServiceSegmentName"})
//    private String yearsOfServiceSegment;

    /**
     * 学历
     */
    @ExcelProperty(value = "学历")
    private String education;

    /**
     * 学位
     */
    @ExcelProperty(value = "学位")
    private String degree;

    /**
     * 毕业时间
     */
    @ExcelProperty(value = "毕业时间")
    private LocalDate graduationDate;

    /**
     * 专业
     */
    @ExcelProperty(value = "专业")
    private String major;

    /**
     * 毕业院校
     */
    @ExcelProperty(value = "毕业院校")
    private String graduateSchool;

    /**
     * 员工类型
     */
    @ExcelProperty(value = "员工类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_EMPLOYEE_TYPE)
    private String employeeType;

//    /**
//     * 员工类型
//     */
////    @ExcelProperty(value = "员工类型")
//    @UnTrans(type= UnTransType.DICTIONARY, dict= HrConstant.HR_EMPLOYEE_TYPE,refs = {"employeeTypeName"})
//    private String employeeType;

    /**
     * 职称情况
     */
    @ExcelProperty(value = "职称情况")
    private String professionalTitle;

    /**
     * 简历
     */
    @ExcelProperty(value = "简历")
    private String resume;

    /**
     * 用工形式
     */
//    @ExcelProperty(value = "用工形式")
    @ExcelProperty(value = "用工形式", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_EMPLOYMENT_FORM)
    private String employmentForm;

//    /**
//     * 用工形式
//     */
////    @ExcelProperty(value = "用工形式")
//    @UnTrans(type= UnTransType.DICTIONARY, dict= HrConstant.HR_EMPLOYMENT_FORM,refs = {"employmentFormName"})
//    private String employmentForm;

    /**
     * 劳动合同期限
     */
    @ExcelProperty(value = "劳动合同期限")
    private String contractTerm;

    /**
     * 劳动合同开始时间
     */
    @ExcelProperty(value = "劳动合同开始时间")
    private LocalDate contractStartDate;

    /**
     * 劳动合同截止时间
     */
    @ExcelProperty(value = "劳动合同截止时间")
    private LocalDate contractEndDate;

    /**
     * 合同到期提醒
     */
    @ExcelProperty(value = "合同到期提醒")
    private LocalDate contractExpirationReminder;

    /**
     * 劳动合同签订情况
     */
    @ExcelProperty(value = "劳动合同签订情况")
    private String contractSigningStatus;

    /**
     * 合同主体
     */
    @ExcelProperty(value = "合同主体")
    private String contractEntity;

    /**
     * 转正时间
     */
    @ExcelProperty(value = "转正时间")
    private LocalDate regularizationDate;

    /**
     * 异动情况
     */
    @ExcelProperty(value = "异动情况")
    private String transferStatus;

    /**
     * 奖惩情况
     */
    @ExcelProperty(value = "奖惩情况")
    private String rewardPunishmentStatus;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remarks;

    /**
     * 离职时间
     */
    @ExcelProperty(value = "离职时间")
    private LocalDate resignationDate;

    /**
     * 离职原因
     */
    @ExcelProperty(value = "离职原因")
    private String resignationReason;



    public void setPlate(String plate) {
        this.plate = plate == null ? null : plate.trim();
    }

    public void setProject(String project) {
        this.project = project == null ? null : project.trim();
    }

    public void setFirstLevelDepartment(String firstLevelDepartment) {
        this.firstLevelDepartment = firstLevelDepartment == null ? null : firstLevelDepartment.trim();
    }

    public void setSecondLevelDepartment(String secondLevelDepartment) {
        this.secondLevelDepartment = secondLevelDepartment == null ? null : secondLevelDepartment.trim();
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId == null ? null : employeeId.trim();
    }

    public void setJobLevel(String jobLevel) {
        this.jobLevel = jobLevel == null ? null : jobLevel.trim();
    }

    public void setPosition(String position) {
        this.position = position == null ? null : position.trim();
    }

    public void setPost(String post) {
        this.post = post == null ? null : post.trim();
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public void setGender(String gender) {
        this.gender = gender == null ? null : gender.trim();
    }

    public void setResumeImage(String resumeImage) {
        this.resumeImage = resumeImage == null ? null : resumeImage.trim();
    }

    public void setIdCardNumber(String idCardNumber) {
        this.idCardNumber = idCardNumber == null ? null : idCardNumber.trim();
    }

    public void setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public void setAgeGroup(String ageGroup) {
        this.ageGroup = ageGroup == null ? null : ageGroup.trim();
    }

    public void setNativePlace(String nativePlace) {
        this.nativePlace = nativePlace == null ? null : nativePlace.trim();
    }

    public void setEthnicity(String ethnicity) {
        this.ethnicity = ethnicity == null ? null : ethnicity.trim();
    }

    public void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus == null ? null : maritalStatus.trim();
    }

    public void setPoliticalStatus(String politicalStatus) {
        this.politicalStatus = politicalStatus == null ? null : politicalStatus.trim();
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber == null ? null : phoneNumber.trim();
    }

    public void setEmergencyContact(String emergencyContact) {
        this.emergencyContact = emergencyContact == null ? null : emergencyContact.trim();
    }

    public void setEmergencyContactPhone(String emergencyContactPhone) {
        this.emergencyContactPhone = emergencyContactPhone == null ? null : emergencyContactPhone.trim();
    }

    public void setHomeAddress(String homeAddress) {
        this.homeAddress = homeAddress == null ? null : homeAddress.trim();
    }

    public void setHouseholdRegistrationAddress(String householdRegistrationAddress) {
        this.householdRegistrationAddress = householdRegistrationAddress == null ? null : householdRegistrationAddress.trim();
    }

    public void setWorkStartDate(LocalDate workStartDate) {
        this.workStartDate = workStartDate;
    }

    public void setEntryDate(LocalDate entryDate) {
        this.entryDate = entryDate;
    }

    public void setYearsOfService(String yearsOfService) {
        this.yearsOfService = yearsOfService == null ? null : yearsOfService.trim();
    }

    public void setYearsOfServiceSegment(String yearsOfServiceSegment) {
        this.yearsOfServiceSegment = yearsOfServiceSegment == null ? null : yearsOfServiceSegment.trim();
    }

    public void setEducation(String education) {
        this.education = education == null ? null : education.trim();
    }

    public void setDegree(String degree) {
        this.degree = degree == null ? null : degree.trim();
    }

    public void setGraduationDate(LocalDate graduationDate) {
        this.graduationDate = graduationDate;
    }

    public void setMajor(String major) {
        this.major = major == null ? null : major.trim();
    }

    public void setGraduateSchool(String graduateSchool) {
        this.graduateSchool = graduateSchool == null ? null : graduateSchool.trim();
    }

    public void setEmployeeType(String employeeType) {
        this.employeeType = employeeType == null ? null : employeeType.trim();
    }

    public void setProfessionalTitle(String professionalTitle) {
        this.professionalTitle = professionalTitle == null ? null : professionalTitle.trim();
    }

    public void setResume(String resume) {
        this.resume = resume == null ? null : resume.trim();
    }

    public void setEmploymentForm(String employmentForm) {
        this.employmentForm = employmentForm == null ? null : employmentForm.trim();
    }

    public void setContractTerm(String contractTerm) {
        this.contractTerm = contractTerm == null ? null : contractTerm.trim();
    }

    public void setContractStartDate(LocalDate contractStartDate) {
        this.contractStartDate = contractStartDate;
    }

    public void setContractEndDate(LocalDate contractEndDate) {
        this.contractEndDate = contractEndDate;
    }

    public void setContractExpirationReminder(LocalDate contractExpirationReminder) {
        this.contractExpirationReminder = contractExpirationReminder;
    }

    public void setContractSigningStatus(String contractSigningStatus) {
        this.contractSigningStatus = contractSigningStatus == null ? null : contractSigningStatus.trim();
    }

    public void setContractEntity(String contractEntity) {
        this.contractEntity = contractEntity == null ? null : contractEntity.trim();
    }

    public void setRegularizationDate(LocalDate regularizationDate) {
        this.regularizationDate = regularizationDate;
    }

    public void setTransferStatus(String transferStatus) {
        this.transferStatus = transferStatus == null ? null : transferStatus.trim();
    }

    public void setRewardPunishmentStatus(String rewardPunishmentStatus) {
        this.rewardPunishmentStatus = rewardPunishmentStatus == null ? null : rewardPunishmentStatus.trim();
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? null : remarks.trim();
    }

    public void setResignationDate(LocalDate resignationDate) {
        this.resignationDate = resignationDate;
    }

    public void setResignationReason(String resignationReason) {
        this.resignationReason = resignationReason == null ? null : resignationReason.trim();
    }
}
