package com.anplus.hr.service;

import com.alibaba.cola.dto.PageResponse;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.EmployeePhoneBookListParam;
import com.anplus.hr.domain.params.EmployeePhoneBookParam;
import com.anplus.hr.domain.vo.EmployeePhoneBookVo;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * 电话本管理Service接口
 *
 * @author LiuBin
 * @date 2025-11-19
 */
public interface EmployeePhoneBookServ extends IService<EmployeeInfo> {


    /**
     * 分页查询电话本管理列表
     *
     * @param param        查询条件
     * @return 电话本管理分页列表
     */
    PageResponse<EmployeePhoneBookVo> queryPageList(EmployeePhoneBookListParam param);

    /**
     * 查询符合条件的电话本管理列表
     *
     * @param param 查询条件
     * @return 电话本管理列表
     */
    List<EmployeePhoneBookVo> queryList(EmployeePhoneBookListParam param);

    /**
     * 查询电话本管理
     *
     * @param id 主键
     * @return 电话本管理
     */
     EmployeePhoneBookVo queryById(Long id);

    /**
     * 新增电话本管理
     *
     * @param param 电话本管理
     * @return 是否新增成功
     */
    Boolean insertByParam(EmployeePhoneBookParam param);

    /**
     * 修改电话本管理
     *
     * @param param 电话本管理
     * @return 是否修改成功
     */
    Boolean updateByParam(EmployeePhoneBookParam param);

    /**
     * 校验并批量删除电话本管理信息
     *
     * @param ids     待删除的主键集合
     * @return 是否删除成功
     */
    Boolean delByIds(List<Long> ids);

}
