package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import cn.idev.excel.annotation.write.style.*;
import cn.idev.excel.enums.poi.FillPatternTypeEnum;
import com.anplus.hr.domain.EmployeeTraining;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Getter;
import lombok.Setter;
import top.binfast.common.excel.bean.ExcelBaseEntity;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author 刘斌
 * @date 2025/12/7 21:18
 */
@Getter
@ExcelIgnoreUnannotated
@ContentRowHeight(20)
@HeadRowHeight(25)
@ColumnWidth(20)
@HeadStyle(fillPatternType = FillPatternTypeEnum.SOLID_FOREGROUND, fillForegroundColor = 40)
@HeadFontStyle(color = 9, fontHeightInPoints = 11)
@AutoMapper(target = EmployeeTraining.class, convertGenerate = false)
public class EmployeeTrainingImportVo extends ExcelBaseEntity implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 姓名
     */
    @ExcelProperty(value = "姓名")
    private String name;

    /**
     * 身份证号
     */
    @ExcelProperty(value = "身份证号")
    private String idCardNumber;

    /**
     * 培训课程
     */
    @ExcelProperty(value = "培训课程")
    private String trainingCourse;

    /**
     * 培训机构
     */
    @ExcelProperty(value = "培训机构")
    private String trainingInstitution;

    /**
     * 培训讲师
     */
    @ExcelProperty(value = "培训讲师")
    private String trainer;

    /**
     * 参训时间
     */
    @Setter
    @ExcelProperty(value = "参训时间")
    private LocalDate trainingTime;

    /**
     * 服务期
     */
    @Setter
    @ExcelProperty(value = "服务期")
    private LocalDate serviceEndDate;

    /**
     * 服务年限
     */
    @ExcelProperty(value = "服务年限")
    private String serviceYears;

    /**
     * 培训金额
     */
    @Setter
    @ExcelProperty(value = "培训金额")
    private BigDecimal trainingAmount;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;


    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public void setTrainingCourse(String trainingCourse) {
        this.trainingCourse = trainingCourse == null ? null : trainingCourse.trim();
    }

    public void setTrainingInstitution(String trainingInstitution) {
        this.trainingInstitution = trainingInstitution == null ? null : trainingInstitution.trim();
    }

    public void setTrainer(String trainer) {
        this.trainer = trainer == null ? null : trainer.trim();
    }

    public void setServiceYears(String serviceYears) {
        this.serviceYears = serviceYears == null ? null : serviceYears.trim();
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public void setIdCardNumber(String idCardNumber) {
        this.idCardNumber = idCardNumber == null ? null : idCardNumber.trim();
    }
}
