package com.anplus.hr.domain.vo;

import com.anplus.hr.domain.EmployeeInfo;
import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMappers;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDate;

/**
 * @author 刘斌
 * @date 2025/12/2 10:54
 */
@Getter
@Setter
@AutoMappers({
        @AutoMapper(target = EmployeeInfo.class, convertGenerate = false),
        @AutoMapper(target = EmployeeFlowVo.class, convertGenerate = false),
})
public class EmployeeFlowRenewalContractApplyVo extends EmployeeFlowVo {

    /**
     * 劳动合同期限
     */
    private String contractTerm;

    /**
     * 合同形式
     */
    private String contractForm;

    /**
     * 劳动合同开始时间
     */
    private LocalDate contractStartDate;

    /**
     * 劳动合同截止时间
     */
    private LocalDate contractEndDate;

    /**
     * 合同主体
     */
    private String contractEntity;

    /**
     * 社保主体
     */
    private String socialSecurityEntity;

    /**
     * 公积金主体
     */
    private String providentFundEntity;

    /**
     * 劳动合同签订情况
     */
    private String contractSigningStatus;
}
