package com.anplus.hr.domain.params;

import lombok.Getter;
import lombok.Setter;
import top.binfast.common.core.bean.params.PageQueryParam;

import java.util.HashMap;
import java.util.Map;

/**
 * 员工部门分页对象 employee_dept
 *
 * @author LiuBin
 * @date 2025-10-30
 */
@Getter
@Setter
public class EmployeeDeptListParam extends PageQueryParam {

    /**
     * 父级部门
     */
    private Long parentId;

    /**
     * 父级部门名称
     */
    private String parentName;

    /**
     * 部门名称
     */
    private String name;

    /**
     * 祖级关系
     */
    private String nodePath;

    /**
     * 显示顺序
     */
    private Long orderNum;

    /**
     * 状态
     */
    private Integer status;


    private Map<String, Object> params = new HashMap<>();

}
