package com.anplus.hr.service;

import com.alibaba.cola.dto.PageResponse;
import com.alibaba.cola.dto.Response;
import com.baomidou.mybatisplus.extension.service.IService;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.*;
import com.anplus.hr.domain.vo.EmployeeInfoImportVo;
import com.anplus.hr.domain.vo.EmployeeInfoVo;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.stream.Stream;

/**
 * 员工信息Service接口
 *
 * @author LiuBin
 * @date 2025-10-28
 */
public interface EmployeeInfoServ extends IService<EmployeeInfo> {


    /**
     * 分页查询员工信息列表
     *
     * @param param        查询条件
     * @return 员工信息分页列表
     */
    PageResponse<EmployeeInfoVo> queryPageList(EmployeeInfoListParam param);

    /**
     * 查询符合条件的员工信息列表
     *
     * @param param 查询条件
     * @return 员工信息列表
     */
    List<EmployeeInfoVo> queryList(EmployeeInfoListParam param);

    /**
     * 导入员工信息列表
     *
     * @param stream 员工信息列表
     * @return 是否导入成功
     */
    Response importEmployeeList(Stream<EmployeeInfoImportVo> stream, MultipartFile file);

    /**
     * 校验员工名称是否唯一
     *
     * @param param 员工信息
     * @return 是否唯一
     */
    Boolean checkEmployeeIdCardNumberUnique(EmployeeInfoParam param);
    /**
     * 查询员工信息
     *
     * @param id 主键
     * @return 员工信息
     */
     EmployeeInfoVo queryById(Long id);

     /**
     * 员工信息详情
     *
     * @param id 主键
     * @return 员工信息
     */
     EmployeeInfoVo infoDetail(Long id);

    /**
     * 新增员工信息
     *
     * @param param 员工信息
     * @return 是否新增成功
     */
    Boolean insertByParam(EmployeeInfoParam param);

    /**
     * 修改员工信息
     *
     * @param param 员工信息
     * @return 是否修改成功
     */
    Boolean updateByParam(EmployeeInfoParam param);

    /**
     * 员工入职申请
     *
     * @param param 参数
     */
    Boolean applyEntry(EmployeeEntryApplyParam param);

    /**
     * 员工调职申请
     *
     * @param param 参数
     */
    Boolean applyTransfer(EmployeeTransferApplyParam param);

    /**
     * 员工离职申请
     *
     * @param param 参数
     */
    Boolean applyResign(EmployeeResignApplyParam param);

    /**
     * 校验并批量删除员工信息信息
     *
     * @param ids     待删除的主键集合
     * @return 是否删除成功
     */
    Boolean delByIds(List<Long> ids);

}
