package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.constant.HrConstant;
import com.anplus.hr.domain.EmployeeInfo;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.core.trans.anno.Trans;
import org.dromara.core.trans.constant.TransType;
import org.dromara.core.trans.vo.TransPojo;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.converters.ExcelDictConvert;
import top.binfast.common.excel.converters.ExcelUrlImageConverter;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;



/**
 * 员工信息视图对象 employee_info
 *
 * @author LiuBin
 * @date 2025-10-28
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = EmployeeInfo.class)
public class EmployeeInfoVo implements TransPojo, Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 序号
     */
    private Long id;

    /**
     * 板块
     */
    @ExcelProperty(value = "板块")
    private String plate;

    /**
     * 项目
     */
    @ExcelProperty(value = "项目")
    private String project;

    /**
     * 一级部门
     */
    @ExcelProperty(value = "一级部门")
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @ExcelProperty(value = "二级部门")
    private String secondLevelDepartment;

    /**
     * 工号
     */
    @ExcelProperty(value = "工号")
    private String employeeId;

    /**
     * 职级
     */
    @ExcelProperty(value = "职级")
    private String jobLevel;

    /**
     * 岗位
     */
    @ExcelProperty(value = "岗位")
    private String position;

    /**
     * 职务
     */
    @ExcelProperty(value = "职务")
    private String post;

    /**
     * 姓名
     */
    @ExcelProperty(value = "姓名")
    private String name;

    /**
     * 性别
     */
    @ExcelProperty(value = "性别", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_USER_SEX)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_USER_SEX)
    private String gender;

    /**
     * 简历图片
     */
    @ExcelProperty(value = "简历图片", converter = ExcelUrlImageConverter.class)
    private String resumeImage;

    /**
     * 身份证号码
     */
    @ExcelProperty(value = "身份证号码")
    private String idCardNumber;

    /**
     * 出生日期
     */
    @ExcelProperty(value = "出生日期")
    private LocalDate birthDate;

    /**
     * 年龄
     */
    @ExcelProperty(value = "年龄")
    private Integer age;

    /**
     * 年龄段
     */
    @ExcelProperty(value = "年龄段", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_AGE_GROUP)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_AGE_GROUP)
    private String ageGroup;

    /**
     * 籍贯
     */
    @ExcelProperty(value = "籍贯")
    private String nativePlace;

    /**
     * 民族
     */
    @ExcelProperty(value = "民族")
    private String ethnicity;

    /**
     * 婚姻状况
     */
    @ExcelProperty(value = "婚姻状况", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_MARITAL_STATUS)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_MARITAL_STATUS)
    private String maritalStatus;

    /**
     * 政治面貌
     */
    @ExcelProperty(value = "政治面貌", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_POLITICAL_STATUS)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_POLITICAL_STATUS)
    private String politicalStatus;

    /**
     * 手机号码
     */
    @ExcelProperty(value = "手机号码")
    private String phoneNumber;

    /**
     * 紧急联系人
     */
    @ExcelProperty(value = "紧急联系人")
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
    @ExcelProperty(value = "紧急联系人电话")
    private String emergencyContactPhone;

    /**
     * 家庭地址
     */
    @ExcelProperty(value = "家庭地址")
    private String homeAddress;

    /**
     * 户口所在地
     */
    @ExcelProperty(value = "户口所在地")
    private String householdRegistrationAddress;

    /**
     * 参加工作时间
     */
    @ExcelProperty(value = "参加工作时间")
    private LocalDate workStartDate;

    /**
     * 入职时间
     */
    @ExcelProperty(value = "入职时间")
    private LocalDate entryDate;

    /**
     * 工龄
     */
    @ExcelProperty(value = "工龄")
    private String yearsOfService;

    /**
     * 工龄段
     */
    @ExcelProperty(value = "工龄段", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_YEARS_SERVICE_SEGMENT)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_YEARS_SERVICE_SEGMENT)
    private String yearsOfServiceSegment;

    /**
     * 学历
     */
    @ExcelProperty(value = "学历")
    private String education;

    /**
     * 学位
     */
    @ExcelProperty(value = "学位")
    private String degree;

    /**
     * 毕业时间
     */
    @ExcelProperty(value = "毕业时间")
    private LocalDate graduationDate;

    /**
     * 专业
     */
    @ExcelProperty(value = "专业")
    private String major;

    /**
     * 毕业院校
     */
    @ExcelProperty(value = "毕业院校")
    private String graduateSchool;

    /**
     * 员工类型
     */
    @ExcelProperty(value = "员工类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_EMPLOYEE_TYPE)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_EMPLOYEE_TYPE)
    private String employeeType;

    /**
     * 职称情况
     */
    @ExcelProperty(value = "职称情况")
    private String professionalTitle;

    /**
     * 简历
     */
    @ExcelProperty(value = "简历")
    private String resume;

    /**
     * 用工形式
     */
    @ExcelProperty(value = "用工形式", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_EMPLOYMENT_FORM)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_EMPLOYMENT_FORM)
    private String employmentForm;

    /**
     * 劳动合同期限
     */
    @ExcelProperty(value = "劳动合同期限")
    private String contractTerm;

    /**
     * 劳动合同开始时间
     */
    @ExcelProperty(value = "劳动合同开始时间")
    private LocalDate contractStartDate;

    /**
     * 劳动合同截止时间
     */
    @ExcelProperty(value = "劳动合同截止时间")
    private LocalDate contractEndDate;

    /**
     * 合同到期提醒
     */
    @ExcelProperty(value = "合同到期提醒")
    private LocalDate contractExpirationReminder;

    /**
     * 劳动合同签订情况
     */
    @ExcelProperty(value = "劳动合同签订情况")
    private String contractSigningStatus;

    /**
     * 合同主体
     */
    @ExcelProperty(value = "合同主体")
    private String contractEntity;

    /**
     * 转正时间
     */
    @ExcelProperty(value = "转正时间")
    private LocalDate regularizationDate;

    /**
     * 异动情况
     */
    @ExcelProperty(value = "异动情况")
    private String transferStatus;

    /**
     * 奖惩情况
     */
    @ExcelProperty(value = "奖惩情况")
    private String rewardPunishmentStatus;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remarks;

    /**
     * 离职时间
     */
    @ExcelProperty(value = "离职时间")
    private LocalDate resignationDate;

    /**
     * 离职原因
     */
    @ExcelProperty(value = "离职原因")
    private String resignationReason;

    /**
     * 是否转正
     */
    @ExcelProperty(value = "是否转正")
    private String onDuty;


}
