package com.anplus.hr.domain.params;

import com.anplus.hr.domain.EmployeeInfo;
import io.github.linpeilie.annotations.AutoMapper;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;

import java.time.LocalDate;

;

/**
 * 员工信息业务对象 employee_info
 *
 * @author LiuBin
 * @date 2025-10-28
 */
@Data
@AutoMapper(target = EmployeeInfo.class, reverseConvertGenerate = false)
public class EmployeeInfoParam {

    /**
     * 序号
     */
    @NotNull(message = "序号不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 板块
     */
    @NotBlank(message = "板块不能为空", groups = { AddGroup.class, EditGroup.class })
    private String plate;

    /**
     * 项目
     */
    @NotBlank(message = "项目不能为空", groups = { AddGroup.class, EditGroup.class })
    private String project;

    /**
     * 一级部门
     */
    @NotBlank(message = "一级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @NotBlank(message = "二级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String secondLevelDepartment;

    /**
     * 部门id
     */
    @NotNull(message = "部门id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long deptId;

    /**
     * 工号
     */
    @NotBlank(message = "工号不能为空", groups = { AddGroup.class, EditGroup.class })
    private String employeeId;

    /**
     * 职级
     */
    @NotBlank(message = "职级不能为空", groups = { AddGroup.class, EditGroup.class })
    private String jobLevel;

    /**
     * 岗位
     */
    @NotBlank(message = "岗位不能为空", groups = { AddGroup.class, EditGroup.class })
    private String position;

    /**
     * 职务
     */
    @NotBlank(message = "职务不能为空", groups = { AddGroup.class, EditGroup.class })
    private String post;

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空", groups = { AddGroup.class, EditGroup.class })
    private String name;

    /**
     * 性别
     */
    @NotBlank(message = "性别不能为空", groups = { AddGroup.class, EditGroup.class })
    private String gender;

    /**
     * 简历图片
     */
    @NotBlank(message = "简历图片不能为空", groups = { AddGroup.class, EditGroup.class })
    private String resumeImage;

    /**
     * 身份证号码
     */
    @NotBlank(message = "身份证号码不能为空", groups = { AddGroup.class, EditGroup.class })
    private String idCardNumber;

    /**
     * 出生日期
     */
    @NotNull(message = "出生日期不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate birthDate;

    /**
     * 年龄
     */
    @NotNull(message = "年龄不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer age;

    /**
     * 年龄段
     */
    @NotBlank(message = "年龄段不能为空", groups = { AddGroup.class, EditGroup.class })
    private String ageGroup;

    /**
     * 籍贯
     */
    @NotBlank(message = "籍贯不能为空", groups = { AddGroup.class, EditGroup.class })
    private String nativePlace;

    /**
     * 民族
     */
    @NotBlank(message = "民族不能为空", groups = { AddGroup.class, EditGroup.class })
    private String ethnicity;

    /**
     * 婚姻状况
     */
    @NotBlank(message = "婚姻状况不能为空", groups = { AddGroup.class, EditGroup.class })
    private String maritalStatus;

    /**
     * 政治面貌
     */
    @NotBlank(message = "政治面貌不能为空", groups = { AddGroup.class, EditGroup.class })
    private String politicalStatus;

    /**
     * 手机号码
     */
    @NotBlank(message = "手机号码不能为空", groups = { AddGroup.class, EditGroup.class })
    private String phoneNumber;

    /**
     * 紧急联系人
     */
    @NotBlank(message = "紧急联系人不能为空", groups = { AddGroup.class, EditGroup.class })
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
    @NotBlank(message = "紧急联系人电话不能为空", groups = { AddGroup.class, EditGroup.class })
    private String emergencyContactPhone;

    /**
     * 家庭地址
     */
    @NotBlank(message = "家庭地址不能为空", groups = { AddGroup.class, EditGroup.class })
    private String homeAddress;

    /**
     * 户口所在地
     */
    @NotBlank(message = "户口所在地不能为空", groups = { AddGroup.class, EditGroup.class })
    private String householdRegistrationAddress;

    /**
     * 参加工作时间
     */
    @NotNull(message = "参加工作时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate workStartDate;

    /**
     * 入职时间
     */
    @NotNull(message = "入职时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate entryDate;

    /**
     * 工龄
     */
    @NotNull(message = "工龄不能为空", groups = { AddGroup.class, EditGroup.class })
    private String yearsOfService;

    /**
     * 工龄段
     */
    @NotBlank(message = "工龄段不能为空", groups = { AddGroup.class, EditGroup.class })
    private String yearsOfServiceSegment;

    /**
     * 学历
     */
    @NotBlank(message = "学历不能为空", groups = { AddGroup.class, EditGroup.class })
    private String education;

    /**
     * 学位
     */
    @NotBlank(message = "学位不能为空", groups = { AddGroup.class, EditGroup.class })
    private String degree;

    /**
     * 毕业时间
     */
    @NotNull(message = "毕业时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate graduationDate;

    /**
     * 专业
     */
    @NotBlank(message = "专业不能为空", groups = { AddGroup.class, EditGroup.class })
    private String major;

    /**
     * 毕业院校
     */
    @NotBlank(message = "毕业院校不能为空", groups = { AddGroup.class, EditGroup.class })
    private String graduateSchool;

    /**
     * 员工类型
     */
    @NotBlank(message = "员工类型不能为空", groups = { AddGroup.class, EditGroup.class })
    private String employeeType;

    /**
     * 职称情况
     */
//    @NotBlank(message = "职称情况不能为空", groups = { AddGroup.class, EditGroup.class })
    private String professionalTitle;

    /**
     * 简历
     */
//    @NotBlank(message = "简历不能为空", groups = { AddGroup.class, EditGroup.class })
    private String resume;

    /**
     * 用工形式
     */
    @NotBlank(message = "用工形式不能为空", groups = { AddGroup.class, EditGroup.class })
    private String employmentForm;

    /**
     * 劳动合同期限
     */
    @NotBlank(message = "劳动合同期限不能为空", groups = { AddGroup.class, EditGroup.class })
    private String contractTerm;

    /**
     * 劳动合同开始时间
     */
    @NotNull(message = "劳动合同开始时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate contractStartDate;

    /**
     * 劳动合同截止时间
     */
    @NotNull(message = "劳动合同截止时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate contractEndDate;

    /**
     * 合同到期提醒
     */
//    @NotNull(message = "合同到期提醒不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate contractExpirationReminder;

    /**
     * 劳动合同签订情况
     */
    @NotBlank(message = "劳动合同签订情况不能为空", groups = { AddGroup.class, EditGroup.class })
    private String contractSigningStatus;

    /**
     * 合同主体
     */
    @NotBlank(message = "合同主体不能为空", groups = { AddGroup.class, EditGroup.class })
    private String contractEntity;

    /**
     * 转正时间
     */
//    @NotNull(message = "转正时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate regularizationDate;

    /**
     * 异动情况
     */
//    @NotBlank(message = "异动情况不能为空", groups = { AddGroup.class, EditGroup.class })
    private String transferStatus;

    /**
     * 奖惩情况
     */
//    @NotBlank(message = "奖惩情况不能为空", groups = { AddGroup.class, EditGroup.class })
    private String rewardPunishmentStatus;

    /**
     * 备注
     */
//    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remarks;

    /**
     * 离职时间
     */
//    @NotNull(message = "离职时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate resignationDate;

    /**
     * 离职原因
     */
//    @NotBlank(message = "离职原因不能为空", groups = { AddGroup.class, EditGroup.class })
    private String resignationReason;


}
