package com.anplus.hr.domain.params;

import lombok.Getter;
import lombok.Setter;
import top.binfast.common.core.bean.params.PageQueryParam;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

;

/**
 * 员工信息分页对象 employee_info
 *
 * @author LiuBin
 * @date 2025-10-28
 */
@Getter
@Setter
public class EmployeeInfoListParam extends PageQueryParam {

    /**
     * 板块
     */
    private String plate;

    /**
     * 项目
     */
    private String project;

    /**
     * 一级部门
     */
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    private String secondLevelDepartment;

    /**
     * 工号
     */
    private String employeeId;

    /**
     * 职级
     */
    private String jobLevel;

    /**
     * 岗位
     */
    private String position;

    /**
     * 职务
     */
    private String post;

    /**
     * 姓名
     */
    private String name;

    /**
     * 性别
     */
    private String gender;

    /**
     * 身份证号码
     */
    private String idCardNumber;

    /**
     * 出生日期
     */
    private LocalDate birthDate;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 年龄段
     */
    private String ageGroup;

    /**
     * 籍贯
     */
    private String nativePlace;

    /**
     * 民族
     */
    private String ethnicity;

    /**
     * 婚姻状况
     */
    private String maritalStatus;

    /**
     * 政治面貌
     */
    private String politicalStatus;

    /**
     * 手机号码
     */
    private String phoneNumber;

    /**
     * 紧急联系人
     */
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
    private String emergencyContactPhone;

    /**
     * 家庭地址
     */
    private String homeAddress;

    /**
     * 户口所在地
     */
    private String householdRegistrationAddress;

    /**
     * 参加工作时间
     */
    private LocalDate workStartDate;

    /**
     * 入职时间
     */
    private LocalDate entryDate;

    /**
     * 工龄
     */
    private String yearsOfService;

    /**
     * 工龄段
     */
    private String yearsOfServiceSegment;

    /**
     * 学历
     */
    private String education;

    /**
     * 学位
     */
    private String degree;

    /**
     * 毕业时间
     */
    private LocalDate graduationDate;

    /**
     * 专业
     */
    private String major;

    /**
     * 毕业院校
     */
    private String graduateSchool;

    /**
     * 员工类型
     */
    private String employeeType;

    /**
     * 职称情况
     */
    private String professionalTitle;

    /**
     * 简历
     */
    private String resume;

    /**
     * 用工形式
     */
    private String employmentForm;

    /**
     * 劳动合同期限
     */
    private String contractTerm;

    /**
     * 劳动合同开始时间
     */
    private LocalDate contractStartDate;

    /**
     * 劳动合同截止时间
     */
    private LocalDate contractEndDate;

    /**
     * 合同到期提醒
     */
    private LocalDate contractExpirationReminder;

    /**
     * 劳动合同签订情况
     */
    private String contractSigningStatus;

    /**
     * 合同主体
     */
    private String contractEntity;

    /**
     * 转正时间
     */
    private LocalDate regularizationDate;

    /**
     * 异动情况
     */
    private String transferStatus;

    /**
     * 奖惩情况
     */
    private String rewardPunishmentStatus;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 离职时间
     */
    private LocalDate resignationDate;

    /**
     * 离职原因
     */
    private String resignationReason;


    private Map<String, Object> params = new HashMap<>();

}
