package com.anplus.hr.mapper;

import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.vo.EmployeeChangeAnalysisVo;
import com.anplus.hr.domain.vo.EmployeeStatusAnalysisVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import top.binfast.common.mybatis.datascope.annotation.DataColumn;
import top.binfast.common.mybatis.datascope.annotation.DataPermission;
import top.binfast.common.mybatis.datascope.core.DeptDataScope;
import top.binfast.common.mybatis.mapper.BinBaseMapper;

import java.util.List;

/**
 * 员工信息Mapper接口
 *
 * @author LiuBin
 * @date 2025-10-28
 */
@Mapper
public interface EmployeeInfoMapper extends BinBaseMapper<EmployeeInfo> {

    @DataPermission(type = DeptDataScope.DATA_SCOPE_TYPE, value = {
            @DataColumn(key = DeptDataScope.DEPT_DATA_SCOPE_KEY, value = "t.dept_id"),
            @DataColumn(key = DeptDataScope.USER_DATA_SCOPE_KEY, value = "t.create_by")
    })
    List<EmployeeChangeAnalysisVo> queryChangeAnalysisList(@Param("beginTime") String beginTime, @Param("endTime") String endTime);

    @DataPermission(type = DeptDataScope.DATA_SCOPE_TYPE, value = {
            @DataColumn(key = DeptDataScope.DEPT_DATA_SCOPE_KEY, value = "t.dept_id"),
            @DataColumn(key = DeptDataScope.USER_DATA_SCOPE_KEY, value = "t.create_by")
    })
    List<EmployeeStatusAnalysisVo> queryStatusAnalysisList();

}
