package com.anplus.hr.domain.vo;

import com.anplus.hr.domain.EmployeeFamilyMembers;
import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import cn.idev.excel.annotation.ExcelIgnore;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.converters.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;



/**
 * 员工家庭主要成员视图对象 employee_family_members
 *
 * @author LiuBin
 * @date 2025-12-04
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = EmployeeFamilyMembers.class)
public class EmployeeFamilyMembersVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 序号
     */
    private Long id;

    /**
     * 员工信息ID
     */
    @ExcelProperty(value = "员工信息ID")
    private Long employeeId;

    /**
     * 关系
     */
    @ExcelProperty(value = "关系")
    private String relation;

    /**
     * 姓名
     */
    @ExcelProperty(value = "姓名")
    private String name;

    /**
     * 出生年月
     */
    @ExcelProperty(value = "出生年月")
    private String birthDate;

    /**
     * 工作单位及职务
     */
    @ExcelProperty(value = "工作单位及职务")
    private String companyAndJob;

    /**
     * 联系方式
     */
    @ExcelProperty(value = "联系方式")
    private String contact;

    /**
     * 是否为紧急联系人
     */
    @ExcelProperty(value = "是否为紧急联系人", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "SYS_YES_NO")
    private String emergencyFlag;


}
