package com.anplus.hr.domain.params;

import com.anplus.hr.domain.EmployeeFlow;
import io.github.linpeilie.annotations.AutoMapper;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

;

/**
 * 人事审批对象业务对象 employee_flow
 *
 * @author LiuBin
 * @date 2025-10-31
 */
@Data
@AutoMapper(target = EmployeeFlow.class, reverseConvertGenerate = false)
public class EmployeeFlowParam {

    /**
     * 主键
     */
    @NotNull(message = "主键不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 流程code
     */
    private String flowCode;

    /**
     * 申请编号
     */
//    @NotBlank(message = "申请编号不能为空", groups = { AddGroup.class, EditGroup.class })
    private String applyCode;

    /**
     * 审批类型
     */
    @NotBlank(message = "审批类型不能为空", groups = { AddGroup.class, EditGroup.class })
    private String flowType;

    /**
     * 员工信息ID
     */
//    @NotNull(message = "员工信息ID不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long employeeId;

    /**
     * 审批日志ID，如（1,2）
     */
    private String logIds;

    /**
     * 开始时间
     */
//    @NotNull(message = "开始时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDateTime startDate;

    /**
     * 结束时间
     */
//    @NotNull(message = "结束时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDateTime endDate;

    /**
     * 状态
     */
//    @NotBlank(message = "状态不能为空", groups = { AddGroup.class, EditGroup.class })
    private String status;

    /**
     * 备注
     */
//    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;

    private Map<String, Object> params = new HashMap<>();

}
