package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnore;
import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.domain.EmployeeInfo;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;



/**
 * 电话本管理视图对象 employee_phone_book
 *
 * @author LiuBin
 * @date 2025-11-19
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = EmployeeInfo.class)
public class EmployeePhoneBookVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @ExcelIgnore
    private Long id;

    /**
     * 板块
     */
    @ExcelProperty(value = "板块")
    private String plate;

    /**
     * 一级部门
     */
    @ExcelProperty(value = "一级部门")
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @ExcelProperty(value = "二级部门")
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    @ExcelProperty(value = "三级部门")
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
    @ExcelIgnore
    private Long deptId;

    /**
     * 主岗位
     */
    @ExcelProperty(value = "岗位")
    private String position;

    /**
     * 姓名
     */
    @ExcelProperty(value = "姓名")
    private String name;

    /**
     * 手机号码
     */
    @ExcelProperty(value = "手机")
    private String phoneNumber;

    /**
     * 办公电话
     */
    @ExcelProperty(value = "办公电话")
    private String officePhone;

    /**
     * 短线
     */
    @ExcelProperty(value = "短线")
    private String shortLine;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remarks;


}
